#!/bin/tcsh

# Delete logfile/errorfile
rm -f surf.err 
rm -f surf.log

rm -f rmserrout.dat
touch rmserrout.dat

# Defaults 

set vp1dl  = 4.0000   # first layer; dl = default land
set vs1dl  = 2.2472
set rho1dl = 2.7000

set vp1ds  = 1.5200   # ds = default sea
set vs1ds  = 0.0000
set rho1ds = 1.0200

set vp2dl  = $vp1dl   # second layer
set vs2dl  = $vs1dl
set rho2dl = $rho1dl
set thick2dl = 4000  # thickness in m; corresponds to water layer + sediment layer for "Sea" case. Check with model!

set vp2ds  = 2.5000   # sediment layer under sea
set vs2ds  = 1.4045
set rho2ds = 2.3000


rm -f ./1Dmodels/*.out
surf96 39   # clean up from old tomography runs

find dispfiles -type f -name "*disp.d" | sort -n > infiles.tmp  # looks into folder dispfiles for files named "*disp.d"
# filename: node-???-disp.d

foreach infile (  `cat infiles.tmp  `) 

	\cp -f $infile ./disp.d

# later: change modl.in so the water depth is taken care off

	set nodenum = `echo $infile | awk -F\/ '{print $(NF)}' | awk -F\- '{print $2}'`
	set outfile = "./1Dmodels/node-$nodenum-modl.out" 

	if ( $nodenum < 0 ) then   # ( $nodenum < 9982 || $nodenum > 10000 )
	# nothing happens
	else

	# use the following lines to continue from break (comment "rm all")
	#test -f $outfile && echo " $outfile already found  -- continue "
	#test -f $outfile && continue 

	touch $outfile

	set wdepthm  = ` cat ./profilesz/$nodenum-x-y-v-1D.dat  | tail -1 | awk '{printf "%04d",$4}'`
	set wdeptabs = ` echo $wdepthm | awk '{if ( $1 < 0 ) {print  (-1*$1)} else { print $1}}'  `	

	#echo "File $infile "

	if ( $wdepthm == 0 ) then
		#echo "INFO: Water depth of 0 found ...."
		set wdepthm = 1
	endif

	if ( $wdepthm > 0 ) then
		#echo "File $infile Land height $wdepthm m  Absolut $wdeptabs"
		#echo "INFO: Now Land "

		set thick1 = $wdeptabs ## Hier wird die die Höhe ü NN zugewiesen
		set vp1    = $vp1dl
		set vs1    = $vs1dl
		set rho1   = $rho1dl

		set thick2 = $thick2dl

                # Now create new model
                # Subnstitute the five values defined above
                # Same procedure for land and sea because variables are set differently

                # \cp -f modl-orig.in modl.in
                ( \rm -f modl.in ) >& /dev/null || echo "ERROR :  WHILE DELETING FILE -- SHOULD NEVER HAPPEN"

                cat modl-final.in | awk '{ if ( NR < 13 ) {print $0} }' >  modl.in    # check name of input model!!

                # Now first layer, first four values
       	        cat modl-final.in | awk -v thick=$thick1  -v vp=$vp1   -v vs=$vs1  -v  rho=$rho1   '{ if ( NR == 13 ) {printf "  %6.4f  %6.4f  %6.4f  %6.4f 0.00  0.00  0.00  0.00  1.00  1.00 \n", (thick/1000),(vp),(vs),(rho)   } }' >> modl.in

                # Now second layer, change only thickness
                cat modl-final.in | awk -v thick=$thick2 -v vp=$vp2dl -v vs=$vs2dl -v  rho=$rho2dl '{ if ( NR == 14 ) {printf "  %6.4f  %6.4f  %6.4f  %6.4f 0.00  0.00  0.00  0.00  1.00  1.00 \n", (thick/1000),(vp),(vs),(rho)   } }' >> modl.in

                cat modl-final.in | awk '{ if ( NR > 14) {print $0} }' >> modl.in
  

	else
		#echo "File $infile Water depth $wdepthm m  Absolut $wdeptabs"
		#echo "INFO: Now Sea "

		set thick1 = $wdeptabs ## Hier wird die Wassertiefe
		set vp1    = $vp1ds
		set vs1    = $vs1ds
		set rho1   = $rho1ds

		set thick2 = ` echo "$thick2dl - $wdeptabs" |  awk '{print ($1-$3)}' ` # 4000 m - Wassertiefe in m
                # Now create new model
                # Subnstitute the five values defined above
                # Same procedure for land and sea because variables are set differently

                # \cp -f modl-orig.in modl.in
                ( \rm -f modl.in ) >& /dev/null || echo "ERROR :  WHILE DELETING FILE -- SHOULD NEVER HAPPEN"

                cat modl-final.in | awk '{ if ( NR < 13 ) {print $0} }' >  modl.in    # check input-model-name!!

                # Now first layer, first four values
                cat modl-final.in | awk -v thick=$thick1  -v vp=$vp1   -v vs=$vs1  -v  rho=$rho1   '{ if ( NR == 13 ) {printf "  %6.4f  %6.4f  %6.4f  %6.4f 0.00  0.00  0.00  0.00  1.00  1.00 \n", (thick/1000),(vp),(vs),(rho)   } }' >> modl.in

                # Now second layer, change only thickness
                cat modl-final.in | awk -v thick=$thick2 -v vp=$vp2ds -v vs=$vs2ds -v  rho=$rho2ds '{ if ( NR == 14 ) {printf "  %6.4f  %6.4f  %6.4f  %6.4f 0.00  0.00  0.00  0.00  1.00  1.00 \n", (thick/1000),(vp),(vs),(rho)   } }' >> modl.in

                cat modl-final.in | awk '{ if ( NR > 14) {print $0} }' >> modl.in


	endif

#continue   # uncomment both to stop before executing tomo but continue above loop 
#exit

	# prepare and do 1D-Inversion:
#	surf96 31 12 0   # fix the halfspace velocity (from DOIT)    # check layer numbers with model!
	surf96 31 11 0

	# echo "File $infile Water depth $wdepthm m  Absolut $wdeptabs"

	if ( $wdepthm > 0 ) then
		echo "INFO: Now Land Inversion "
	else
		echo "INFO: Now Sea Inversion "
		surf96 48 1 0  #   turn off smoothing for the water layer
		surf96 31 1 0  #   and do not change the velocity
	endif

	#####
	surf96 32 10  #   start with a lot of damping

#	# For debugginh 
#	echo "#########"  >>  surf.err  
#	echo "$infile" >>  surf.err  
#	cat  modl.in   >>  surf.err  
#	echo "#########"  >>  surf.err  
#	echo "$infile" >>  surf.err  
#	cat  $infile   >>  surf.err  
#
#	cat $infile| awk '{print $6,$7}' | plot_xy_points

#	echo "Return to continue"
#	set a = $< 
	
	( surf96 37 15 1 2 6 >> surf.log )  >>&  surf.err   #   do 15 iterations
	echo "#########"  >>  surf.err  
	
#	surf96 1 7  # compute the predicted vel. for this model and plot
	surf96 28 modl.out  # save the model

	\cp modl.out $outfile  || echo "ERROR COULD NOT COPY TO $outfile  "   
	# save model as outfile ("node-???-modl.out")

	surf96 39
	endif
        
        set rmserr = `cat surf.log | grep "std err" | tail -1 | awk '{print $7}'`
	echo "$nodenum $rmserr" >> rmserrout.dat
end
 
