#!/bin/tcsh

set outdirdepthslices = ./outxyz
set outdir = 		$outdirdepthslices

rm -f ./outxyz/*.xyz

@ a = 13

while  ( $a <=  23 )  # adjust this for number of layers!! 
	echo $a
	set layernum = `echo "$a - 12" | bc -l`
	
	find 1Dmodels -type f -name "*.out" | sort -n > modlfiles.tmp 
#	set thick = `cat ./1Dmodels/node-11918-modl.out | awk -v "line=$a" '{if (NR==line){print $1}}'`
	set outfile = "$outdir/layer$layernum-vs-100421-every10th.xyz"     # look here !
	
	foreach model (  `cat modlfiles.tmp  `) 
		set nodenum =  `echo $model | awk -F\/ '{print $(NF)}' | awk -F\- '{print $2}'`
		
		#set velp = `cat $model | awk -v "line=$a" '{if (NR==line){print $2}}'`
		set vels = `cat $model | awk -v "line=$a" '{if (NR==line){print $3}}'`
		#set rho = `cat $model | awk -v "line=$a" '{if (NR==line){print $4}}'`
		
		if ($vels == "") then
			echo "no s-velocity for this point!"
		
		else 

			set x = `cat "./profilesz/$nodenum-x-y-v-1D.dat" | awk '{if (NR==1){print $7}}'`
			set y = `cat "./profilesz/$nodenum-x-y-v-1D.dat" | awk '{if (NR==1){print $8}}'`
			
			printf " $x $y $vels \n " | column -t 	| tee -a $outfile
		endif
		

	end
	@ a++
	
end
