#!/bin/tcsh


set outdirdepthslices = ./profilesz
set outdir = 		$outdirdepthslices
(mkdir $outdirdepthslices  > &  /dev/null ) 


set bathy = ./Grids/grdcut-new.grd
test -f $bathy || echo "Bathymety not found $bathy -- exit  "
test -f $bathy || exit

#printf "" > $outfile
find $outdir  -type f -name "*1D.dat" | xargs rm -v # removes all exisiting 1D.dat files in outdir


# Assume that all files have the same grid spacing and size 
# Extract x,y z for each node 

# Just use some values, use every XXX value only 
set JUSTUSEEVERY = 10 

set GRDFILE = ` find Grids -type f -name "*debugged-clipped.grd" | sort -n | head -1  `  # look here!

gmt grd2xyz $GRDFILE | awk '{print $1,$2}' | awk -v ignore=$JUSTUSEEVERY '{ if ( NR%ignore == 0 ) {print $0}}' > x-y-nodes.tmp 

cat x-y-nodes.tmp  | awk '{print $1}' > x-values.tmp 
cat x-y-nodes.tmp  | awk '{print $2}' > y-values.tmp

wc -l x-values.tmp   y-values.tmp  x-y-nodes.tmp 

# Extract depths of grids 
#find ./Grids -type f -name "*debugged-clipped.grd" | grep -v cut | awk -F- '{print $(NF)}' | sed -e 's/per//g' | sed -e 's/per//g' | sed -e 's/\.grd//g' | sort -n > depths.dat  # look here!
find ./Grids -type f -name "*debugged-clipped.grd-xyz.dat" | grep -v cut | sort -n > z-xy-v-files.tmp   # look here!

@ a = 0

set num =  ` cat  x-values.tmp   | wc -l  `

# Loop for each line of file 
while  ( $a < $num  )
	@ a++

	set a = `  echo $a | awk '{printf "%03d",$1}' `

	# printf "\n" 

	# set xy = ` get_line.pl -l $a x-y-nodes.tmp  `
	set x  = ` get_line.pl -l $a x-values.tmp `
	set y  = ` get_line.pl -l $a y-values.tmp `

	set outfile = "$a-x-y-v-1D.dat"

	printf ""							| tee -a $outdir/$outfile
	printf "# Node $a / $num : $x $y ---- Depths " | column -t 	| tee -a $outdir/$outfile

	foreach zfile  ( ` cat z-xy-v-files.tmp ` ) 
		#set zvalue = ` echo $zfile | awk -F- '{print $(NF-1)}' | sed -e 's/per//g' | sed -e 's/per//g' | sed -e 's/\.grd//g' | head -1  `  old one
		set zvalue = ` echo $zfile | awk -F- '{print $(2)}' | sed -e 's/per//g' | head -1  `  # for *500runs.grd-xyz.dat       #look here!! check if period is written!

		cat  $zfile | awk -v x=$x -v z=$zvalue -v y=$y '{if ( $1 == x && $2 == y ){print $0}}'  > line1.tmp # line1.tmp contains x,y and fitting v value

		set vvalue  = ` cat line1.tmp | awk '{print $3}' `  # get velocity from line1.tmp

		if ($vvalue == "NaN") then
			#echo "NaN found -- do not print line"
		else
			printf " $zvalue " | tee -a $outdir/$outfile  # prints period
			cat line1.tmp | tee -a $outdir/$outfile  # prints x y v values
		endif

		#echo "$x $y $zvalue"
		#wc line1.tmp $zfile 
		#exit
		

#		test $vvalue = "NaN" && echo "NaN found -- delete file and jump to next node" 
#		test $vvalue = "NaN" && \rm -f $outdir/$outfile
#		test $vvalue = "NaN" && break


# idea: comment the "test $vvalue" part, write the file anyway, check for number of lines and delete it if NR < 10 
# see tmp.tcsh
# important: if "NaN": awk '{}'

	end
		

	#test $vvalue = "NaN" && goto IGNORE
	set wdepth = `  echo "$x $y " | gmt grdtrack -GGrids/grdcut-new.grd | awk '{print $3}' | head -1  `
	printf " ## Water depth  $wdepth $x $y  " | column -t 	| tee -a $outdir/$outfile
	#IGNORE:

	printf "\n"
	
	if (`cat $outdir/$outfile | wc -l` < 10 ) then
	\rm -f $outdir/$outfile
	endif
end 


touch aa.tmp

exit  

exit 


