#!/bin/tcsh

rm -f rmserr.xyz


set outfile = "rmserr.xyz"    

set seq1 = `cat rmserrout.dat | head -1 | awk '{print $1}' `
set seq2 = `cat rmserrout.dat | tail -1 | awk '{print $1}' `
#echo "$seq1 $seq2"

foreach line (`seq $seq1 $seq2`)
	set nodenum = `cat rmserrout.dat | grep ^$line | awk '{print $1}'`
	#echo "$nodenum"
	if ($nodenum == "") then
		continue
	endif	
	#echo "node $nodenum"
	set x = `cat "./profilesz/$nodenum-x-y-v-1D.dat" | awk '{if (NR==1){print $7}}'`
	set y = `cat "./profilesz/$nodenum-x-y-v-1D.dat" | awk '{if (NR==1){print $8}}'`
	set err = `cat rmserrout.dat | grep ^$nodenum | awk '{print $2}'`
	
	#echo " $x $y $err \n "
	printf " $x $y $err \n " | column -t | tee -a $outfile
	

end

