%%        MATLAB code that calculates the Eshelby's tensor
% Input: Elastic stiffness tensor of anisotropic inclusion Cij            |
%        Shear modulus and bulk modulus the host mineral: G and K         |
% Output: Eshelby's tensor Sij                                            |
%         dimensionless tensor Mij                                        |
% Developer: Xin Zhong, Freie University Berlin, Germany                  |
% Contact: xinzhong0708@gmail.com                                         |
%==========================================================================

%% Start
clear;close all;clc;addpath([cd,'/bin']);format short

%% Inputs
%Inclusion
C_incl     =   [87.26    6.57   11.95 -17.18     .00    .00
                 6.57   87.26   11.95  17.18     .00    .00
                11.95   11.95  105.80    .00     .00    .00
               -17.18   17.18     .00  57.15     .00    .00
                  .00     .00     .00    .00   57.15 -17.18
                  .00     .00     .00    .00  -17.18  40.35];   % Quartz (Heyliger 2003)
%Host
G_host     =     94.9;
K_host     =    172.6;
v_host     =   (3*K_host-2*G_host)/2/(3*K_host+G_host);

%Ellipsoidal inclusion's axes length (aligned parallel with x, y, z)
a          =    3;
b          =    2;
c          =    1;

%% Calculate Eshelby's tensor (do not change)
S          =    Eshelby_Tensor_Order(a,b,c,v_host);

%% Calculate M matrix (do not change)
C_host     =    Stiffness_Matrix(G_host,K_host);
M          =    inv(C_incl-C_host*(eye(6)-inv(S)))*C_incl;

%% Display
disp(['Axes lengths: ',num2str([a,b,c])])
disp('Eshelby tensor (Sij)');disp(S)
disp('Mij matrix');disp(M)


