function [S] = Calc_S(a,v,I,Iij)

%Compute the Eshelby tensor
S          =   cell(3,3,3,3);  S(:,:,:,:)={0};
S{1,1,1,1} =   3/8/pi/(1-v)*a(1)^2*Iij{1,1} + (1-2*v)/8/pi/(1-v)*I{1};
S{2,2,2,2} =   3/8/pi/(1-v)*a(2)^2*Iij{2,2} + (1-2*v)/8/pi/(1-v)*I{2};
S{3,3,3,3} =   3/8/pi/(1-v)*a(3)^2*Iij{3,3} + (1-2*v)/8/pi/(1-v)*I{3};

S{1,1,2,2} =   1/8/pi/(1-v)*a(2)^2*Iij{1,2} - (1-2*v)/8/pi/(1-v)*I{1};
S{2,2,1,1} =   1/8/pi/(1-v)*a(1)^2*Iij{1,2} - (1-2*v)/8/pi/(1-v)*I{2};
S{1,1,3,3} =   1/8/pi/(1-v)*a(3)^2*Iij{1,3} - (1-2*v)/8/pi/(1-v)*I{1};
S{3,3,1,1} =   1/8/pi/(1-v)*a(1)^2*Iij{1,3} - (1-2*v)/8/pi/(1-v)*I{3};
S{2,2,3,3} =   1/8/pi/(1-v)*a(3)^2*Iij{2,3} - (1-2*v)/8/pi/(1-v)*I{2};
S{3,3,2,2} =   1/8/pi/(1-v)*a(2)^2*Iij{2,3} - (1-2*v)/8/pi/(1-v)*I{3};

S{1,2,1,2} =   (a(1)^2+a(2)^2)/16/pi/(1-v)*Iij{1,2} + (1-2*v)/16/pi/(1-v)*(I{1}+I{2});
S{2,1,1,2} =   S{1,2,1,2};
S{1,2,2,1} =   S{1,2,1,2};
S{2,1,2,1} =   S{1,2,1,2};

S{1,3,1,3} =   (a(1)^2+a(3)^2)/16/pi/(1-v)*Iij{1,3} + (1-2*v)/16/pi/(1-v)*(I{1}+I{3});
S{3,1,3,1} =   S{1,3,1,3};
S{1,3,3,1} =   S{1,3,1,3};
S{3,1,1,3} =   S{1,3,1,3};

S{2,3,2,3} =   (a(2)^2+a(3)^2)/16/pi/(1-v)*Iij{2,3} + (1-2*v)/16/pi/(1-v)*(I{2}+I{3});
S{3,2,3,2} =   S{2,3,2,3};
S{2,3,3,2} =   S{2,3,2,3};
S{3,2,2,3} =   S{2,3,2,3};

end