function [S] = Eshelby_Tensor_Order(a1,a2,a3,nu_host)
%Add random
rng(1)
a1  =  a1 + sign(rand-0.5)*((2e-4)*rand+2e-4);
a2  =  a2 + sign(rand-0.5)*((2e-4)*rand+2e-4);
a3  =  a3 + sign(rand-0.5)*((2e-4)*rand+2e-4);

% Sort the three axis length
a   =  sort([a1,a2,a3],'descend');

% Calculate the normal Eshelby tensor
A   =  Eshelby_Tensor(a(1),a(2),a(3),nu_host);

% Six scenarios possible
%%  a1>a2>a3
if a1 > a2 && a2 > a3
    S(1,1) =  A(1,1);
    S(2,2) =  A(2,2);
    S(3,3) =  A(3,3);
    S(1,2) =  A(1,2);
    S(2,1) =  A(2,1);
    S(1,3) =  A(1,3);
    S(3,1) =  A(3,1);
    S(2,3) =  A(2,3);
    S(3,2) =  A(3,2);
    S(4,4) =  A(4,4);
    S(5,5) =  A(5,5);
    S(6,6) =  A(6,6);
end
%%  a1>a3>a2
if a1 > a3 && a3 > a2
    S(1,1) =  A(1,1);
    S(3,3) =  A(2,2);
    S(2,2) =  A(3,3);
    S(1,3) =  A(1,2);
    S(3,1) =  A(2,1);
    S(1,2) =  A(1,3);
    S(2,1) =  A(3,1);
    S(3,2) =  A(2,3);
    S(2,3) =  A(3,2);
    S(4,4) =  A(4,4);
    S(6,6) =  A(5,5);
    S(5,5) =  A(6,6);
end
%%  a2>a1>a3
if a2 > a1 && a1 > a3
    S(2,2) =  A(1,1);
    S(1,1) =  A(2,2);
    S(3,3) =  A(3,3);
    S(2,1) =  A(1,2);
    S(1,2) =  A(2,1);
    S(2,3) =  A(1,3);
    S(3,2) =  A(3,1);
    S(1,3) =  A(2,3);
    S(3,1) =  A(3,2);
    S(5,5) =  A(4,4);
    S(4,4) =  A(5,5);
    S(6,6) =  A(6,6);
end
%%  a2>a3>a1
if a2 > a3 && a3 > a1
    S(2,2) =  A(1,1);
    S(3,3) =  A(2,2);
    S(1,1) =  A(3,3);
    S(2,3) =  A(1,2);
    S(3,2) =  A(2,1);
    S(2,1) =  A(1,3);
    S(1,2) =  A(3,1);
    S(3,1) =  A(2,3);
    S(1,3) =  A(3,2);
    S(5,5) =  A(4,4);
    S(6,6) =  A(5,5);
    S(4,4) =  A(6,6);
end
%%  a3>a2>a1
if a3 > a2 && a2 > a1
    S(3,3) =  A(1,1);
    S(2,2) =  A(2,2);
    S(1,1) =  A(3,3);
    S(3,2) =  A(1,2);
    S(2,3) =  A(2,1);
    S(3,1) =  A(1,3);
    S(1,3) =  A(3,1);
    S(2,1) =  A(2,3);
    S(1,2) =  A(3,2);
    S(6,6) =  A(4,4);
    S(5,5) =  A(5,5);
    S(4,4) =  A(6,6);
end
%%  a3>a1>a2
if a3 > a1 && a1 > a2
    S(3,3) =  A(1,1);
    S(1,1) =  A(2,2);
    S(2,2) =  A(3,3);
    S(3,1) =  A(1,2);
    S(1,3) =  A(2,1);
    S(3,2) =  A(1,3);
    S(2,3) =  A(3,1);
    S(1,2) =  A(2,3);
    S(2,1) =  A(3,2);
    S(6,6) =  A(4,4);
    S(4,4) =  A(5,5);
    S(5,5) =  A(6,6);
end

end