function [A,B] = Fit_Ellip(dx,dy,dz,D)

%Display
disp('Data loaded, calculating');pause(0.5)

%Pre-process
x1         =  dx:dx:dx*size(D,1);
y1         =  dy:dy:dy*size(D,2);
z1         =  dz:dz:dz*size(D,3);
[x3,y3,z3] =  ndgrid(x1,y1,z1);
x_poly     =  x3(D==1);
y_poly     =  y3(D==1);
z_poly     =  z3(D==1);

%Volume of the shape
V_tot      =  sum(D(:))*dx*dy*dz;

%Calculate centroid and shift the inclusion
xc         =  sum(x_poly(:))/(sum(D(:)));  x_poly=x_poly-xc;
yc         =  sum(y_poly(:))/(sum(D(:)));  y_poly=y_poly-yc;
zc         =  sum(z_poly(:))/(sum(D(:)));  z_poly=z_poly-zc;

%Plot inclusion
subplot(121);hold on;plot3(x_poly,y_poly,z_poly);view(3);axis equal;xlabel('x');ylabel('y');grid on;box on;title('Inclusion')

%Calculate covarance matrix
Ix         =  sum((y_poly.^2+z_poly.^2)*dx*dy*dz);
Iy         =  sum((x_poly.^2+z_poly.^2)*dx*dy*dz);
Iz         =  sum((x_poly.^2+y_poly.^2)*dx*dy*dz);
Ixy        =  sum(-x_poly.*y_poly *dx*dy*dz);
Ixz        =  sum(-x_poly.*z_poly *dx*dy*dz);
Iyz        =  sum(-y_poly.*z_poly *dx*dy*dz);

OMEGA      = [Ix  Ixy Ixz
              Ixy Iy  Iyz
              Ixz Iyz Iz ]/V_tot;
[V,EIG]    =  eig(OMEGA); EIG=diag(EIG);

%Eigenvalue and eigenvector
I1         =  EIG(1);
I2         =  EIG(2);
I3         =  EIG(3);
n          =  sum(D(:));
a_fit      =  sqrt(5/2/(n*dx*dy*dz)*(I2+I3-I1));
b_fit      =  sqrt(5/2/(n*dx*dy*dz)*(I1+I3-I2));
c_fit      =  sqrt(5/2/(n*dx*dy*dz)*(I1+I2-I3));

%Re-orient axes
axes    = ([a_fit,b_fit,c_fit]);

%Scale the axes
axes    =  axes*(V_tot/(4/3*pi*axes(1)*axes(2)*axes(3)))^(1/3);

%Find orientation
[~,p1]  =  min(EIG);  ori_max =  V(:,p1);
[~,p3]  =  max(EIG);  ori_min =  V(:,p3);
p2      =  median(EIG);  p2 = (p2==EIG); ori_med =  V(:,p2);

%Save result
A      =  axes;
B      = [ori_max(:)' ; ori_med(:)' ; ori_min(:)'];

%Plot result
xlim(1.1*[min(x_poly),max(x_poly)]);ylim(1.1*[min(y_poly),max(y_poly)]);zlim(1.1*[min(z_poly),max(z_poly)]);zlabel('z')
subplot(122);axis equal;hold on;view(3)
plot3([0,A(1)*B(1,1)]*1.00 , [0,A(1)*B(1,2)]*1.00 , [0,A(1)*B(1,3)]*1.00 , 'r-' ,'LineWidth',3)
plot3([0,A(2)*B(2,1)]*1.00 , [0,A(2)*B(2,2)]*1.00 , [0,A(2)*B(2,3)]*1.00 , 'b-' ,'LineWidth',3);
plot3([0,A(3)*B(3,1)]*1.00 , [0,A(3)*B(3,2)]*1.00 , [0,A(3)*B(3,3)]*1.00 , 'k-' ,'LineWidth',3);
xlim(1.1*[min(x_poly),max(x_poly)]);ylim(1.1*[min(y_poly),max(y_poly)]);zlim(1.1*[min(z_poly),max(z_poly)])
grid on;box on;xlabel('x');ylabel('y');zlabel('z')
view(3);title('Red-longest; Blue-middle; Black-shortest')

disp('Done. Display the result')

end
