function [C] = Rotation_4nd(C,phi1,psi,phi2)
%Rotation following Bunge convention (ZXZ order)
%convert from 2D to 4D tensor
b     = [1 6 5 6 2 4 5 4 3];
A     = reshape(bsxfun(@plus,b(:),(b-1)*6),3,3,3,3);
C     = reshape(C(A(:)),[3 3 3 3]);

%rotation
R     =  ([cos(phi2)*cos(phi1)-sin(phi2)*sin(phi1)*cos(psi)  cos(phi2)*sin(phi1)+sin(phi2)*cos(phi1)*cos(psi) sin(psi)*sin(phi2)
          -sin(phi2)*cos(phi1)-cos(phi2)*sin(phi1)*cos(psi) -sin(phi2)*sin(phi1)+cos(phi2)*cos(phi1)*cos(psi) sin(psi)*cos(phi2)
           sin(psi )*sin(phi1)                              -sin(psi )*cos(phi1)                              cos(psi)        ])';

%initialize
C1111 = 0;
C1122 = 0;
C1133 = 0;
C1123 = 0;
C1113 = 0;
C1112 = 0;
C2222 = 0;
C2233 = 0;
C2223 = 0;
C2213 = 0;
C2212 = 0;
C3333 = 0;
C3323 = 0;
C3313 = 0;
C3312 = 0;
C2323 = 0;
C2313 = 0;
C2312 = 0;
C1313 = 0;
C1312 = 0;
C1212 = 0;

%rotation loop
for m = 1:3
    for n = 1:3
        for o = 1:3
            for p = 1:3
                C1111 = C1111 + R(1,m)*R(1,n)*R(1,o)*R(1,p)*C(m,n,o,p);
                C1122 = C1122 + R(1,m)*R(1,n)*R(2,o)*R(2,p)*C(m,n,o,p);
                C1133 = C1133 + R(1,m)*R(1,n)*R(3,o)*R(3,p)*C(m,n,o,p);
                C1123 = C1123 + R(1,m)*R(1,n)*R(2,o)*R(3,p)*C(m,n,o,p);
                C1113 = C1113 + R(1,m)*R(1,n)*R(1,o)*R(3,p)*C(m,n,o,p);
                C1112 = C1112 + R(1,m)*R(1,n)*R(1,o)*R(2,p)*C(m,n,o,p);
                C2222 = C2222 + R(2,m)*R(2,n)*R(2,o)*R(2,p)*C(m,n,o,p);
                C2233 = C2233 + R(2,m)*R(2,n)*R(3,o)*R(3,p)*C(m,n,o,p);
                C2223 = C2223 + R(2,m)*R(2,n)*R(2,o)*R(3,p)*C(m,n,o,p);
                C2213 = C2213 + R(2,m)*R(2,n)*R(1,o)*R(3,p)*C(m,n,o,p);
                C2212 = C2212 + R(2,m)*R(2,n)*R(1,o)*R(2,p)*C(m,n,o,p);
                C3333 = C3333 + R(3,m)*R(3,n)*R(3,o)*R(3,p)*C(m,n,o,p);
                C3323 = C3323 + R(3,m)*R(3,n)*R(2,o)*R(3,p)*C(m,n,o,p);
                C3313 = C3313 + R(3,m)*R(3,n)*R(1,o)*R(3,p)*C(m,n,o,p);
                C3312 = C3312 + R(3,m)*R(3,n)*R(1,o)*R(2,p)*C(m,n,o,p);
                C2323 = C2323 + R(2,m)*R(3,n)*R(2,o)*R(3,p)*C(m,n,o,p);
                C2313 = C2313 + R(2,m)*R(3,n)*R(1,o)*R(3,p)*C(m,n,o,p);
                C2312 = C2312 + R(2,m)*R(3,n)*R(1,o)*R(2,p)*C(m,n,o,p);
                C1313 = C1313 + R(1,m)*R(3,n)*R(1,o)*R(3,p)*C(m,n,o,p);
                C1312 = C1312 + R(1,m)*R(3,n)*R(1,o)*R(2,p)*C(m,n,o,p);
                C1212 = C1212 + R(1,m)*R(2,n)*R(1,o)*R(2,p)*C(m,n,o,p);
            end
        end
    end
end

C               =  [C1111,C1122,C1133,C1123,C1113,C1112;...
                    C1122,C2222,C2233,C2223,C2213,C2212;...
                    C1133,C2233,C3333,C3323,C3313,C3312;...
                    C1123,C2223,C3323,C2323,C2313,C2312;...
                    C1113,C2213,C3313,C2313,C1313,C1312;...
                    C1112,C2212,C3312,C2312,C1312,C1212];
end