function [C] = Stiffness_Matrix(G,K)
v        =  (3*K-2*G)/2/(3*K+G);
lb       =   2*G*v/(1-2*v);
C11      =   lb+2*G;
C12      =   lb;
C44      =   G;
C        =  [C11 C12 C12 0   0   0
             C12 C11 C12 0   0   0 
             C12 C12 C11 0   0   0
             0   0   0   C44 0   0 
             0   0   0   0   C44 0
             0   0   0   0   0   C44];  
end