%% Program to calculate lattice strain tensor from lattice parameters
% The inputs are:
% a0, b0, c0, alpha0, beta0, gamma0: lattice parameters at reference state
% a, b, c, alpha, beta, gamma: lattice parameters at high P-T state
% The outputs are:
% Linear Lagrangian strain (infinitesimal small strain measure)
% Finite Lagrangian strain (large strain measure)
% The results are numerically close for small strain, e.g. solid inclusion
% Contact: Xin Zhong (xinzhong0708@gmail.com) FU Berlin, Germany
clear;close all;clc;addpath([cd,'/bin']);format long
%==========================================================================

%% Reference state (room P-T condition)
%a b c parameters at reference condition
a0      =  5.0;
b0      =  5.0;
c0      =  5.0;
%alpha-beta-gamma at reference condition
alpha0  =  85/180*pi;
beta0   =  84/180*pi;
gamma0  =  88/180*pi;

%% Deformed state at high P-T condition
%a b c parameters after deformation
a       =  5.1;
b       =  5.2;
c       =  5.3;
%alpha-beta-gamma after deformation
alpha   =  84/180*pi;
beta    =  85/180*pi;
gamma   =  89/180*pi;

%% Calculator (please do not change)
[E1,E2] =  Calc_Strain(a0,b0,c0,alpha0,beta0,gamma0,a,b,c,alpha,beta,gamma);

%% Display
disp('Linear Lagrangian strain tensor based on lattice parameters');disp(E1)
disp('Finite Lagrangian strain tensor based on lattice parameters');disp(E2);disp('Done!')