function [Strain1,Strain2] = Calc_Strain(a1,b1,c1,alpha1,beta1,gamma1,a2,b2,c2,alpha2,beta2,gamma2)
disp('Calculate strain in Cartesian coordinate with unit cell parameters')
disp('Convention: Z-axis // c-axis; X-axis // a*-axis')
%Q1
p1      =  sqrt(1-cos(alpha1)^2-cos(beta1)^2-cos(gamma1)^2 + 2*cos(alpha1)*cos(beta1)*cos(gamma1));
Q1      = [a1*p1/sin(alpha1)  a1*(cos(gamma1)-cos(alpha1)*cos(beta1))/sin(alpha1)  a1*cos(beta1)  ; ...
           0                  b1*sin(alpha1)                                       b1*cos(alpha1) ; ...
           0                   0                                                   c1            ];

%Q1
p2      =  sqrt(1-cos(alpha2)^2-cos(beta2)^2-cos(gamma2)^2 + 2*cos(alpha2)*cos(beta2)*cos(gamma2));
Q2      = [a2*p2/sin(alpha2)  a2*(cos(gamma2)-cos(alpha2)*cos(beta2))/sin(alpha2)  a2*cos(beta2)  ; ...
           0                  b2*sin(alpha2)                                       b2*cos(alpha2) ; ...
           0                   0                                                   c2            ];
%Infinitesmal strain
E       =  inv(Q1)*Q2 - eye(3);
Strain1 = (E + E')/2;

%Finite strain
F       =  inv(Q1)*Q2;
F       =  F*F';
Strain2 = (F-eye(3))/2;

%Round strain
Strain1 =  round(Strain1*1e10)/1e10;
Strain2 =  round(Strain2*1e10)/1e10;
end