function [s] = Cube_Root(a0,a1,a2)
% This function solves the equation:
% x^3 + a2*x^2 + a1*x + a0 = 0
% Input: a0 a1 a2
% Output: three solutions for x
% a0 a1 a2 can be vectors with same length n, then solution will be a matrix
% composed of three rows and n column

%% Constants
p     = (3*a1-a2.^2)/3;
q     = (9*a1.*a2-27*a0-2*a2.^3)/27;

%% Right hand sides for w3
RHS1  =  1/2*(q+sqrt(q.^2+4/27*p.^3));
RHS2  =  1/2*(q-sqrt(q.^2+4/27*p.^3));

w1    =  exp(2*pi*i*(0:2)/3)'*nthroot(RHS1,3);
w2    =  exp(2*pi*i*(0:2)/3)'*nthroot(RHS2,3);

%% Use Vieta's substitution
x1    =  w1-p./3./w1;
x2    =  w2-p./3./w2;

%% Find solution
s     =  [x1;x2]-1/3*a2;

end

