function [S] = Eshelby_Tensor(a1,a2,a3,v)

%Theta and k
k      =  sqrt((a1^2-a2^2)/(a1^2-a3^2));
theta  =  asin(sqrt(1-a3^2/a1^2));

%Compute elliptic integrals
[F,E]  =  elliptici(theta,k^2);

%Compute I coefficients
I1     =  4*pi*a1*a2*a3/((a1^2-a2^2)*sqrt(a1^2-a3^2))*(F-E);
I3     =  4*pi*a1*a2*a3/((a2^2-a3^2)*sqrt(a1^2-a3^2))*(a2*sqrt(a1^2-a3^2)/a1/a3-E);
I2     =  4*pi-I1-I3;

I12    = (I2-I1)/(a1^2-a2^2);
I13    = (I3-I1)/(a1^2-a3^2);
I23    = (I3-I2)/(a2^2-a3^2);

I11    = (4*pi/a1^2-I12-I13)/3;
I22    = (4*pi/a2^2-I12-I23)/3;
I33    = (4*pi/a3^2-I13-I23)/3;

%Compute Eshelby Tensor
S(1,1) =  3/8/pi/(1-v)*a1^2*I11 + (1-2*v)/8/pi/(1-v)*I1;
S(2,2) =  3/8/pi/(1-v)*a2^2*I22 + (1-2*v)/8/pi/(1-v)*I2;
S(3,3) =  3/8/pi/(1-v)*a3^2*I33 + (1-2*v)/8/pi/(1-v)*I3;
S(1,2) =  1/8/pi/(1-v)*a2^2*I12 - (1-2*v)/8/pi/(1-v)*I1;
S(2,1) =  1/8/pi/(1-v)*a1^2*I12 - (1-2*v)/8/pi/(1-v)*I2;
S(1,3) =  1/8/pi/(1-v)*a3^2*I13 - (1-2*v)/8/pi/(1-v)*I1;
S(3,1) =  1/8/pi/(1-v)*a1^2*I13 - (1-2*v)/8/pi/(1-v)*I3;
S(2,3) =  1/8/pi/(1-v)*a3^2*I23 - (1-2*v)/8/pi/(1-v)*I2;
S(3,2) =  1/8/pi/(1-v)*a2^2*I23 - (1-2*v)/8/pi/(1-v)*I3;
S(4,4) =  (a2^2+a3^2)/16/pi/(1-v)*I23 + (1-2*v)/16/pi/(1-v)*(I2+I3);
S(5,5) =  (a1^2+a3^2)/16/pi/(1-v)*I13 + (1-2*v)/16/pi/(1-v)*(I1+I3);
S(6,6) =  (a1^2+a2^2)/16/pi/(1-v)*I12 + (1-2*v)/16/pi/(1-v)*(I1+I2);

%Convert to Engineering convention for Voigt multiplication
S(4,4) =   2*S(4,4);
S(5,5) =   2*S(5,5);
S(6,6) =   2*S(6,6);

end

