function [SOL] = Root_Ellipoid(x1,x2,x3,a1,a2,a3)
% solution of x1^2/(a1^2+s) + x2^2/(a2^2+s) + x3^2/(a3^2+s) = 1
% converted into s^3 + B*s^2 + C*s + D = 0
% Three roots are found that are separately evalutated to find largest one

% Coefficients
B    =   a1^2+a2^2+a3^2-x1.^2-x2.^2-x3.^2;
C    =   a1^2*a2^2+a1^2*a3^2-a1^2*x2.^2-a1^2*x3.^2+a2^2*a3.^2-a2^2*x1.^2-a2^2*x3.^2-a3^2*x1.^2-a3^2*x2.^2;
D    =   a1^2*a2^2*a3^2-a1^2*a2^2*x3.^2-a1^2*a3^2*x2.^2-a2^2*a3^2*x1.^2;

%Solutions possible
SOL1 =  (4.*B.^2-2.*B.*(-8.*B.^3+36.*C.*B-108.*D+12.*sqrt(81.*D.^2+(12.*B.^3-54.*B.*C).*D-3.*C.^2.*B.^2+12.*C.^3)).^(1./3)-12.*C+(-8.*B.^3+36.*C.*B-108.*D+12.*sqrt(81.*D.^2+(12.*B.^3-54.*B.*C).*D-3.*C.^2.*B.^2+12.*C.^3)).^(2./3))./(6.*(-8.*B.^3+36.*C.*B-108.*D+12.*sqrt(81.*D.^2+(12.*B.^3-54.*B.*C).*D-3.*C.^2.*B.^2+12.*C.^3)).^(1./3));
SOL2 = -((-i.*sqrt(3).*(1./4)+1./4).*(-8.*B.^3+36.*C.*B-108.*D+12.*sqrt(81.*D.^2+(12.*B.^3-54.*B.*C).*D-3.*C.^2.*B.^2+12.*C.^3)).^(2./3)+B.*(-8.*B.^3+36.*C.*B-108.*D+12.*sqrt(81.*D.^2+(12.*B.^3-54.*B.*C).*D-3.*C.^2.*B.^2+12.*C.^3)).^(1./3)+(B.^2-3.*C).*(i.*sqrt(3)+1))./(3.*(-8.*B.^3+36.*C.*B-108.*D+12.*sqrt(81.*D.^2+(12.*B.^3-54.*B.*C).*D-3.*C.^2.*B.^2+12.*C.^3)).^(1./3));
SOL3 =  ((-i.*sqrt(3).*(1./4)-1./4).*(-8.*B.^3+36.*C.*B-108.*D+12.*sqrt(81.*D.^2+(12.*B.^3-54.*B.*C).*D-3.*C.^2.*B.^2+12.*C.^3)).^(2./3)-B.*(-8.*B.^3+36.*C.*B-108.*D+12.*sqrt(81.*D.^2+(12.*B.^3-54.*B.*C).*D-3.*C.^2.*B.^2+12.*C.^3)).^(1./3)+(B.^2-3.*C).*(i.*sqrt(3)-1))./(3.*(-8.*B.^3+36.*C.*B-108.*D+12.*sqrt(81.*D.^2+(12.*B.^3-54.*B.*C).*D-3.*C.^2.*B.^2+12.*C.^3)).^(1./3));

%Largest root
SOL  =   max(real([SOL1;SOL2;SOL3]));

end