function [C] = Rotation_1nd(C,phi1,psi,phi2)
%Rotation following Bunge convention (ZXZ order)
C     =  [C(1) C(2) C(3)];

%rotation
R     =  ([cos(phi2)*cos(phi1)-sin(phi2)*sin(phi1)*cos(psi)  cos(phi2)*sin(phi1)+sin(phi2)*cos(phi1)*cos(psi) sin(psi)*sin(phi2)
          -sin(phi2)*cos(phi1)-cos(phi2)*sin(phi1)*cos(psi) -sin(phi2)*sin(phi1)+cos(phi2)*cos(phi1)*cos(psi) sin(psi)*cos(phi2)
           sin(psi )*sin(phi1)                              -sin(psi )*cos(phi1)                              cos(psi)        ])';

%initialize
C1    = 0;
C2    = 0;
C3    = 0;

%rotation loop
for m = 1:3
    C1 = C1 + R(1,m)*C(m);
    C2 = C2 + R(2,m)*C(m);
    C3 = C3 + R(3,m)*C(m);
end

C     =  [C1;C2;C3];

end