function [C] = Rotation_2nd(C,phi1,psi,phi2)

%Rotation following Bunge convention (ZXZ order)
C     =  [C(1) C(6) C(5)
          C(6) C(2) C(4)
          C(5) C(4) C(3)];

%rotation
R     =  ([cos(phi2)*cos(phi1)-sin(phi2)*sin(phi1)*cos(psi)  cos(phi2)*sin(phi1)+sin(phi2)*cos(phi1)*cos(psi) sin(psi)*sin(phi2)
          -sin(phi2)*cos(phi1)-cos(phi2)*sin(phi1)*cos(psi) -sin(phi2)*sin(phi1)+cos(phi2)*cos(phi1)*cos(psi) sin(psi)*cos(phi2)
           sin(psi )*sin(phi1)                              -sin(psi )*cos(phi1)                              cos(psi)        ])';

%initialize
C11   = 0;
C22   = 0;
C33   = 0;
C23   = 0;
C13   = 0;
C12   = 0;

%rotation loop
for m = 1:3
    for n = 1:3
        C11 = C11 + R(1,m)*R(1,n)*C(m,n);
        C22 = C22 + R(2,m)*R(2,n)*C(m,n);
        C33 = C33 + R(3,m)*R(3,n)*C(m,n);
        C23 = C23 + R(2,m)*R(3,n)*C(m,n);
        C13 = C13 + R(1,m)*R(3,n)*C(m,n);
        C12 = C12 + R(1,m)*R(2,n)*C(m,n);
    end
end

C     =  [C11;C22;C33;C23;C13;C12];

end