function [wie]=eff2lnofe_vi(wieff, th, lam, phig)
% ------------------------------------------------------------------------|
% DESCRIPTION
% - rotates acceleration vector and Eotvos tensor from Earth Fixed Frame
%   to Local North Oriented Frame: EFF->LNOFe
% use:
% [wie]=eff2lnofe(wieff, phi,lam, phig)
% ------------------------------------------------------------------------|
% INPUT:
% wieff - acceleration vector, [whatever] ... mGal or m/s^2, matrix(:,:,3)
% th - matrix(:,:) with polar angle = 90-geocentric latitude, [rad]
% lam-  matrix(:,:) with longitude, [rad]
% phig - matrix(:,:) with geodetic/ellipsoidal latitude, [rad]
% ------------------------------------------------------------------------|
% OUTPUT:
% wie - acceleration vector in LNOFe
%     - wie(:,:,1) = Wx
%     - wie(:,:,2) = Wy
%     - wie(:,:,3) = Wz
% ------------------------------------------------------------------------|
% OTHERS:
% JS(12-2011)
% ------------------------------------------------------------------------|
% REFERENCES
% ------------------------------------------------------------------------|
[s1,s2,s3a]=size(wieff);
wie=zeros(s1,s2,s3a);

Rlam=zeros(3,3,s2);
for j=1:s2
    Rlam(:,:,j)=rz((lam(1,j)-pi));
end

for i=1:s1
   R1a=ry(-th(i,1));
   
   % angle for LNOFs -> LNOFe
   alpha=(phig(i,1)-(pi/2-th(i,1)));
   R2=ry(alpha);
       
   for j=1:s2           
       
       % EFF -> LNOFs
       R1=R1a*Rlam(:,:,j); % right handed system, 
       
       % LNOFs -> LNOFe
       R=R2*R1;
       
       wieff0  = [wieff(i,j,1); wieff(i,j,2); wieff(i,j,3)];

       % rotation into LNOFe
       wilnofe  = R*wieff0;
       wie(i,j,1) = wilnofe(1);
       wie(i,j,2) = wilnofe(2);
       wie(i,j,3) = wilnofe(3);
     
   end    
end