"""
Scrpit used for converting reported Mg content into XMgCO$_3$ in Gilgannon and Herwegh (2025)


Equations used are in the methods second of the publication.

AUTHOR
    James Gilgannon
    email: jamesgilgannon@hotmail.com

REVISION
    1 (2025-04-07)

"""

import numpy as np

### Define AMU weights for elements and molecules of interest ------------------
MW_Ca = 40.08
MW_Mg = 24.31
MW_C = 12.01
MW_O = 16.00
MW_CaCO3 = MW_Ca +  MW_C + (MW_O*3)
MW_MgCO3 = MW_Mg +  MW_C + (MW_O*3)
MW_MgO = MW_Mg +  MW_O



### If Mg ppm(w) in marble -----------------------------------------------------
# ppm_w_Mg =1209.1
# wt_fraction = ppm_w_Mg * 1e-6
# x_denominator = MW_CaCO3 - MW_MgCO3 + (MW_Mg/wt_fraction)
# x = MW_CaCO3/x_denominator
# print (x)


### If MgCO3 in marble -----------------------------------------------------
# wt_fraction = 0.0023
# x_denominator = MW_CaCO3 - MW_MgCO3 + (MW_MgCO3/wt_fraction)
# x = MW_CaCO3/x_denominator
# print(x)

### If MgO in marble -----------------------------------------------------
# wt_fraction =  0.022
# x_denominator = MW_CaCO3 - MW_MgCO3 + (MW_MgO/wt_fraction)
# x = MW_CaCO3/x_denominator
# print (x)
