# README  

The data contained in this directory is used for Fig. 3 in the paper 
"Kinematics of the South Atlantic Rift" by Heine et al,
2013 [10.5194/sed-5-41-2013](http://dx.doi.org/10.5194/sed-5-41-2013). 

The figure is a set of 10 crustal scale cross sections along the conjugate 
South Atlantic margins, with Moho, Top Basement and Seafloor horizons. These
have been used to generate palinspastically restored continental margin widths.

Christian Heine, Sydney, 2013-03-18  
[Email me](mailto:christian.heine@sydney.edu.au)  

Data served by [the DataHub](http://datahub.io/data/southatlanticrift)  

This README has 3 parts and is written in MultiMarkdown: 

1 - Citation  
2 - Data format  
3 - License  

## CITATION

To properly attribute the data when using them, please cite the following two 
papers:

O. A. Blaich, J. I. Faleide, and F. Tsikalas. Crustal breakup and continent-ocean transition at South Atlantic conjugate margins. J. Geophys. Res., 116(B1):B01402, 2011. doi:[10.1029/2010JB007686](http://dx.doi.org/10.1029/2010JB007686).

C. Heine, J. Zoethout, R. D. Müller. Kinematics of the South Atlantic Rift.
Solid Earth (in review), doi: [10.5194/sed-5-41-2013](http://dx.doi.org/10.5194/sed-5-41-2013)

## DATA FORMAT

The files contained in this zip archives are lon/lat/depth (meters) line
segments, representing the depth of the main crustal units (Moho, Basement,
Seabed). The files are simple ASCII text multi-segments files, 
ready to be plotted using [GMT](http://gmt.soest.hawaii.edu) as in Figure 3 of
the paper. They also contain point positions (or vertical lines) for the 
different interpretations of the COB or landward limit of the oceanic crust
(LALOC).

Segment header names should be self-explanatory.

## LICENSE

The data contained in this archive are made available under a

CREATIVE COMMONS ATTRIBUTION SHARE ALIKE LICENSE. 

This means:

**You are free:**  

- to Share - to copy, distribute and transmit the work  
- to Remix - to adapt the work  
- to make commercial use of the work  

**Under the following conditions:**

- Attribution - You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).

- Share Alike - If you alter, transform, or build upon this work, you may distribute the resulting work only under the same or similar license to this one.

With the understanding that:

- Waiver - Any of the above conditions can be waived if you get permission from the copyright holder.
- Public Domain - Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.
- Other Rights - In no way are any of the following rights affected by the license:
	- Your fair dealing or fair use rights, or other applicable copyright
	exceptions and limitations;
	- The author's moral rights;
	- Rights other persons may have either in the work itself or in how the
	work is used, such as publicity or privacy rights.

Notice - For any reuse or distribution, you must make clear to others the license terms of this work. The best way to do this is with a link to this [web page](http://creativecommons.org/licenses/by-sa/3.0/)

EOF