function [c,hD,vD,hDi,vDi,mvD,b]=stripstar(g,bins,varargin)
% This function is based on stripstarD, written by Renee Heilbronner and 
% on astrip written by Ondrej Lexa as a Matlab implementation of stripstar,
% modified by RKilian to correctly determine a 3D sphere diameter 
% distribution from 2d grainsize.
%
% Syntax: [c,hD,vD,hDi,vDi,mvD,b]=stripstar(g,bins);
% input:
% g    - grain diamteres (eq. diameter)
% bins - vector of bins (right edges)
%
% output:
% c    - centres of bins
% hD   - 3d frequencies
% vD   - volume fractions
% hDi  - 3d frequencies   including antispheres
% vDi  - volume fractions including antispheres
% mvD  - vol weighted mean
% b    - input bins
%
% options:
% nohist : do not plot a histogram

% bins and bincenters 
b= bins(:)';
nbins=length(bins)-1;
ded=diff(b);
c=cumsum([b(1)+ded(1)/2 ded(2:end)])';

% make a re hist
n=histc(g,b);
n(end-1)=n(end-1)+n(end);
n(end)=0;
na=n(1:end-1);
V=zeros(nbins);
% strip it back
for i=1: nbins
    for j=i: nbins
        V(i,j)=(sqrt(j^2-(i-1)^2)-sqrt(j^2-i^2))/j;
    end
end
% make it work correctly
for i=1:nbins
    V(:,i)= V(:,i)/nbins*i;
end
% prep output
hD=inv(V)*na;
vD=2/3*pi*c.^3.*hD;
hDi=100*hD/sum(abs(hD));
vDi=100*vD/sum(abs(vD));
hD(hD<0)=0;
vD(vD<0)=0;
hD=100*hD/sum(hD);
vD=100*vD/sum(vD);

mvD=(c'*hD)/sum(hD);
% eventually plot a histogram
if isempty(varargin)  | ~strcmpi(varargin{1},'nohist')
    subplot(1,3,1)
    bar(c,[hDi vDi],1);
    xlabel('equivalent diameter');
    ylabel('%');
    legend({'3D diameter','Volume fraction'});
    title('3D diameters incl. antispheres')
    subplot(1,3,2)
    bar(c,[hD vD],1);
    xlabel('equivalent diameter');
    ylabel('%');
    legend({'3D diameter','Volume fraction'});
    title('3D diameters')
    subplot(1,3,3)
    bar(c,n(1:end-1));
    xlabel('equivalent diameter');
    ylabel('counts');
    legend({'2D diameters'});
    title('2D input')
end
end

