c-----------------------------------------------------------------------
       program stripstar
c-----------------------------------------------------------------------
       parameter (n_class=100)
       parameter (n_in=5)
       parameter (n_out=6)
       
       character*40 filnam, file_in, file_out
       
       dimension r(n_class,n_class)
       dimension sum(n_class)
       dimension recalc(n_class)
       dimension g(n_class)
       dimension gg(n_class)
       dimension rr(n_class)
       dimension f(n_class)
       dimension fneg(n_class)
       dimension fvol(n_class), fvox(n_class), vsize(n_class)

c-----------------------------------------------------------------------
c   initialize

       do j=1,n_class
       sum(j)=0.0000
       f(j)=0.0000
       recalc(j)=0.0000
       do i=1,n_class
       r(i,j)=0.0000
       enddo
       enddo

c-----------------------------------------------------------------------
c   input

       write(n_out,99)
99     format(
     . ' ----------------------------------------------------------'/
     . ' ***  stripstar for diameters ***            2016-11-11, rh'/
     . ' ----------------------------------------------------------'/
     . ' this program derives a possible distribution of spheres'/
     . ' from measured distributions of sectional areas.'/
     . ' it requires input in the form of binned data: '/
     . ' histogram h(d) where d = diameter,  h = number frequency'/
     . ' calculates means of all calculated distributions'/
     . ' upgrade: max = 100 bins - variable output'/
     . ' ----------------------------------------------------------')

       write(n_out,103)
103    format(/'indicate if input is manual (0) or by file (1) >')    
       read(n_in,*) nchoice

       if(nchoice.eq.0) go to 3

2      write(n_out,100) n_class
100    format(/'file must contain list of h(r) '/
     .'line 1: no. of bins (max. = ',i2,'), width of bin'/
     .'line 2 ff.: h(d)')
       write(n_out,104)
104    format(/'name of input file > ')
       read(n_in,210) file_in
210    format(a)

c-----------------------------------------------------------------------
c   read input file

       open(unit=1,file=file_in, status='old')
       read(1,*) n,clinc
       do i=1,n
       read(1,*,err=2) g(i)
       enddo
220    format(i10)   
       close(unit=1)

       go to 4

c-----------------------------------------------------------------------
c   manual input

3      continue

1      write(n_out,101) n_class
101    format(/'indicate number of classes of histogram'/
     .'h(d (up to ',i2,') >')
       read(n_in,220) n
       if(n.gt.n_class) go to 1

       write(n_out,113)
113    format(/'indicate class width of h(d) (mm/inch/units/...) > ')
       read(n_in,*) clinc
       
5      write(n_out,105) n
105    format(/'type ',i2,' input frequencies (# or %)',
     .' (from smallest to largest)')
       do i=1,n
       write(n_out,102) i
       read(n_in,*,err=5) g(i)
       enddo
102    format('bin no.',i2,': ')

4      continue

c-----------------------------------------------------------------------
c   choice of output

       write(n_out,114)
114    format(/'how much output ?'/
     . '1= file only, 12= file + statistics, 123= all, verbose  > ')
       read(n_in,220) iout

c-----------------------------------------------------------------------
c   output file

       write(n_out,108) 
108    format(/'name of output file >')
       read(n_in,210) file_out

       open(unit=2,file=file_out,status='new')   


c-----------------------------------------------------------------------
c      test if g(n) is zero - keep nn

       nn=n
       do j=1,n
       k=n+1-j
       if (g(k).gt.0.0000) go to 7
       enddo
7      continue
       n=k
       write(n_out,230) n
230    format(/'largest no-zero bin is h(',i2,')'/)
       
c-----------------------------------------------------------------------
c   calculate distribution of sections for uniform distribution of r

       do j=1,n
       do i=1,j
       i1=i-1
       jj=j*j
       r(i,j)= (sqrt(float(jj-i1*i1))-sqrt(float(jj-i*i))) / n
       enddo
       enddo
c
       do i=1,n
       do j=1,n
       sum(i)=sum(i)+r(i,j)
       enddo
       enddo

c-----------------------------------------------------------------------
c   optional print distribution of sections for uniform distribution of r
c   de-star if you want matrix
*
*       write(n_out,206)
*206    format(/'matrix r(i,j):')   
*       write(n_out,208)
*208    format('i (row)    = size of section,'/
*     .        'j (column) = produced by size of sphere'/)
*
*        do i=1,n
*        print *,' ',i,(r(i,j),j=1,n)
*        enddo
*
c   end of de-star
c-----------------------------------------------------------------------

*------output option 123--------

       if(iout.ne.123) go to 700

       write(n_out,207)
207    format(/'h(d) for uniform h(d)')
*       write(n_out,2077)
2077   format('= row sum of matrix d(section size,of sphere size)')


       do i=1,n
       write(n_out,205) i,sum(i)
       enddo
      
201    format(1x,i3,1x,10f8.5)
2001   format(5x,10i8)

*------end output option 123--------

700    continue

c-----------------------------------------------------------------------
c   analysis of historgram of sections (input)

       do i=1,n
       gg(i)=g(i)*r(n,n)/g(n)
       enddo

5000   continue
       do k=1,n
       m=n-k+1
       factor=gg(m)/r(m,m)
       if(factor.gt.0.0000) f(m)= factor
       fneg(m)= factor
        do i=1,n
        gg(i)=gg(i)-factor*r(i,m)
c       if(gg(i).lt.0.0000) gg(i)=0.00
        enddo
       enddo
       
c-----------------------------------------------------------------------
c   recalculate sections from positive radii
c
       gsum=0.0
       do i=1,n
       gg(i)=g(i)/g(n)
       gsum=gsum+g(i)
       enddo

       do i=1,n
       do j=1,n
       recalc(i)=recalc(i)+r(i,j)*f(j)
       enddo
       enddo
       do i=1,n
       recalc(i)=recalc(i)/recalc(n)
       enddo
       

*------output option 123 part 2--------

       if(iout.ne.123) go to 701

       write(n_out,204)
204    format(/)
       write(n_out,203) n
203    format(t13,'calculated distributions:',t46,'comparison:'/
     . t13,'spheres',t25,'sph.& antispheres',t46,
     .     'rel.input sections',t67,'recalc.sections'/
     . '  class',t13,'h(D)',t25,'h*(D)',t46,
     . '(h(',i2,') = 1.00):',t67,'from h(D):'/)
       do i=1,n
       write(n_out,205) i,f(i), fneg(i), gg(i), recalc(i)
       enddo
205    format(i5,2f15.5,t45,2f16.5)

       write(n_out,204)
       write(n_out,217)

*------end output option 123 part 2 --------

701    continue

c-----------------------------------------------------------------------
c   write output file - titles

       write(2,217)
217    format(t25,'d=diameter of sections,  D=diameter of spheres'/
     . t25,'spheres only', t50, 'spheres & antispheres'/
     . t9,'d',t13,'h(d)(%)',t25,
     .    'h(D)(%)',t37,'v(D)(%)',t50,'h*(D)(%)',t64,'v*(D)(%)'/)

c-----------------------------------------------------------------------
c   weight percent

       sumf=0.0000
       sumv=0.0000
       sumn=0.0000
       sumx=0.0000
       
       do i=1,n
       sumf=sumf+f(i)
*       sumn=sumn+abs(fneg(i))        ! is same as sumf (...)
       sumn=sumn+fneg(i)       
       x=i*clinc
       vsize(i)=x*x*x*4.1887902    ! = 4*3.14159/3 * r*r*r
       fvol(i)=f(i)*vsize(i)
       fvox(i)=fneg(i)*vsize(i)
       sumv=sumv+fvol(i)
*       sumx=sumx+abs(fvox(i))        ! is same as sumv (...)
       sumx=sumx+fvox(i)  
       enddo
       
       do i=1,n
       f(i)=100.0*f(i)/sumf
       fneg(i)=100.0*fneg(i)/sumn    ! same as f(i)
       fvol(i)=100.0*fvol(i)/sumv
       fvox(i)=100.0*fvox(i)/sumx    ! same as fvol(i)
       g(i)=100.0*g(i)/gsum
       enddo
       
       do i=1,nn        ! corrected at DRT
       rr(i)=i*clinc
       enddo
       

c-----------------------------------------------------------------------
c   write output

       if(n.eq.nn) go to 250

       do i=n+1,nn
       g(i)=0.0
       f(i)=0.0
       fvol(i)=0.0
       fneg(i)=0.0
       fvox(i)=0.0
       enddo

250    do i=1,nn
       write(2,215) rr(i), g(i), f(i), fvol(i), fneg(i), fvox(i)
       enddo

215    format(f9.3,f10.2,2f12.2,t48,f10.2,t62,f10.2)

*------output option 123 part 3 --------

       if(iout.ne.123) go to 702

       do i=1,n
       write(n_out,215) rr(i), g(i), f(i), fvol(i), fneg(i), fvox(i)
       enddo

       write(n_out,204)

*------end output option 123 part 3 --------

702    continue

      
c-----------------------------------------------------------------------
c   calculate statistics

*------output option 12 or 123 (write stats) --------

       if(iout.eq.1) go to 703

       write(n_out,255)
255    format('-------------------------------------------------------')
       write(n_out,244) file_out
244    format('statistics for output file ',a)
       write(n_out,245)
245    format('(data not saved - need to copy from screen):')

       write(n_out,705)
*       write(2,705)
705    format(/t29,'mean',t37,'variance',t50,'st.dev.',t63,'skewn.')

       write(n_out,709)
*       write(2,709)
       call stath(n,rr,g,gm)
       
       write(n_out,710)
*       write(2,710)
       call stath(n,rr,f,fm)
       
       write(n_out,711)
*       write(2,711)
       call stath(n,rr,fvol,fvolm)

       write(n_out,712)
*       write(2,712)
       call stath(n,rr,fneg,fnegm)

       write(n_out,713)
*       write(2,713)
       call stath(n,rr,fvox,fvoxm)
       
709    format('statistics of d')
710    format('statistics of D')
711    format('statistics of V')
712    format('statistics of D*')
713    format('statistics of V*')

       write(n_out,255)

*------end output option 12 or 123 (write stats) --------

703    continue

       close(unit=2)

       print *,' '
       end

c-----------------------------------------------------------------------
       subroutine stath(n,x,h,xmean)

       dimension x(100), h(100)
       dimension sum(3), stat(4)

c       do i=1,n
c       print *,i,x(i),h(i)
c       enddo

c-----------------------------------------------------------------------
c   starting conditions

       hsum=0.
       do i=1,3
       sum(i)=0.
       enddo
       do i=1,4
       stat(i)=0.
       enddo

c-----------------------------------------------------------------------
c   statistics: correct right edge to center of bin

       x2=0.5*(x(2)-x(1))
       
       do 100 i=1,n
       if(h(i).lt.0.0) h(i)=0.00
       hsum=hsum+h(i)
       do 100 j= 1,3
       sum(j)= sum(j) + ((x(i)-x2)**j)*h(i)
100    continue

c       write(6,703) hsum
c703    format(/' sum of h(i): ',f12.5)

       stat(1) = sum(1)/hsum
      
       if (n.le.1) go to 4000
       
       stat(2)= (sum(2)-(sum(1)*sum(1)/hsum))/(hsum)
       fract=stat(2)
       if(stat(1).ne.0.) fract=fract/stat(1)
       if(fract.lt.1.e-06.or.stat(2).le.0.) go to 50
       stat(3)= sqrt(stat(2))
       
50     continue
       if(stat(3).eq.0.) go to 4000
       do 70 i=1,3
70     sum(i)= sum(i)/hsum
       sss=stat(3)*stat(3)*stat(3)
       sum3=sum(1)*sum(1)*sum(1)
       stat(4)= (sum(3) -3.*sum(1)*sum(2) +2.*sum3)/ sss

4000   continue

c-----------------------------------------------------------------------
c   print on screen only

       write(6,706) (stat(ii),ii=1,4)
*       write(2,706) (stat(ii),ii=1,4)
706    format(20x,4f12.5)
   

c-----------------------------------------------------------------------
c   end

       return
       end

