
% Code that plots the velocity profiles up to base of the North Sea Group for each station of the
% Groningen Network

% By Janneke van Ginkel, October 2019 (j.a.van.ginkel@rug.nl,
% j.a.vanginkel@gmail.com)

stname='G25';  % station name as listed in the first column of the data file, e.g. 'G25'

% load the velocities from the data file 
fname='Velocities_NSG.csv'; 
fid=fopen(fname,'r');
C=textscan(fid,'%s%f%f%f%f%f%f%f','delimiter',',', 'Headerlines',1);
stnames=C{1};
Vs_50=C{2};
Vs_100=C{3};
Vs_150=C{4};
Vs_200=C{5};
Vs_NSG=C{6};
Vs_NSL=C{7};
depth_NSG=C{8};


% vectorize the corresponding velocities and NSG depth to the stname
[tf,ix]=ismember(stname, stnames);

if tf==1
    Vs50=Vs_50(ix);
    Vs100=Vs_100(ix);
    Vs150=Vs_150(ix);
    Vs200=Vs_200(ix);
    VsNSG=Vs_NSG(ix);
    VsNSL=Vs_NSL(ix);
    zNSG=depth_NSG(ix);
    doplot=1;
else 
    disp(['No S-wave velocities available for station ',num2str(stname)]);
    doplot=0;
end

z=[0;50;50;100;100;150;150;200;200;zNSG]; % depth vector
Vs=[Vs50;Vs50;Vs100;Vs100;Vs150;Vs150;Vs200;Vs200;VsNSL;VsNSL]; % shear wave velocity vector 

% plotting
if doplot==1
    figure('color','w')
    plot(Vs,z,'LineWidth',3.0);
    set(gca,'ydir','reverse');
    set(gca,'FontSize',14);
    xlabel('Velocity [m/s]')
    ylabel('Depth [m]')
    title(['S-wave velocity, ',stname])
    xlim([0 800])
    ylim([min(z) max(z)])
    set(gca,'PlotBoxAspectRatio',[1 2 1])
    set(gca,'LooseInset',get(gca,'TightInset'));
    grid on
end