
DefineConstant[ h = {0.1, Min 0, Max 1, Name "Domain resolution" } ];

DefineConstant[ ly = {0.6, Min 0.1, Max 0.9, Name "Side point" } ];

SetFactory("OpenCASCADE");

Point(1) = {0, 0, 0, h};
Point(2) = {1, 0, 0, h};
Point(3) = {1, 1, 0, h};
Point(4) = {0, 1, 0, h};

Point(5) = {0, 0.5, 0, h};
Point(6) = {1, ly, 0, h};



Line(1) = {1,2};

Line(2) = {2,6};
Line(3) = {6,3};

Line(4) = {3,4};

Line(5) = {4,5};
Line(6) = {5,1};

Line(7) = {5,6};

Line Loop(5) = {1, 2, -7, 6};
Line Loop(6) = {7, 3, 4, 5};

Plane Surface(5) = {5};
Plane Surface(6) = {6};


Physical Curve(1) = {1}; // bottom : tag 1
Physical Curve(2) = {2,3,5,6}; // left right : tag 2
Physical Curve(3) = {4}; // top : tag 3

Physical Surface(1) = {5}; // volume (lower) : tag 1
Physical Surface(2) = {6}; // volume (upper) : tag 2

Mesh.MshFileVersion = 2.2;
