/*@ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 **
 **    Copyright (c) 2012
 **        Dave A. May [dave.may@erdw.ethz.ch]
 **        Institute of Geophysics
 **        ETH Zürich
 **        Sonneggstrasse 5
 **        CH-8092 Zürich
 **        Switzerland
 **
 **    project:    pTatin3d
 **    filename:   MaterialConst_DensityBoussinesq_def.c
 **
 **
 **    pTatin3d is free software: you can redistribute it and/or modify
 **    it under the terms of the GNU General Public License as published
 **    by the Free Software Foundation, either version 3 of the License,
 **    or (at your option) any later version.
 **
 **    pTatin3d is distributed in the hope that it will be useful,
 **    but WITHOUT ANY WARRANTY; without even the implied warranty of
 **    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **    See the GNU General Public License for more details.
 **
 **    You should have received a copy of the GNU General Public License
 **    along with pTatin3d. If not, see <http://www.gnu.org/licenses/>.
 **
 ** ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ @*/



/*
  Auto generated by version 0.0 of swarm_class_generator.py
  on les-MacBook-Pro.local, at 2013-03-08 17:43:59.345563 by laetitia
*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "material_constants/MaterialConst_DensityBoussinesq_def.h"


const char MaterialConst_DensityBoussinesq_classname[] = "MaterialConst_DensityBoussinesq";

const int MaterialConst_DensityBoussinesq_nmembers = 3;

const size_t MaterialConst_DensityBoussinesq_member_sizes[] = {
  1 * sizeof(double),
  1 * sizeof(double),
  1 * sizeof(double)
} ;

const char *MaterialConst_DensityBoussinesq_member_names[] = {
  "density",
  "thermalexpension",
  "compressibility"
} ;


/* ===================================== */
/* Getters for MaterialConst_DensityBoussinesq */
/* ===================================== */
void MaterialConst_DensityBoussinesqGetField_density(MaterialConst_DensityBoussinesq *point,double *data)
{
  *data = point->density;
}

void MaterialConst_DensityBoussinesqGetField_thermalexpension(MaterialConst_DensityBoussinesq *point,double *data)
{
  *data = point->alpha;
}

void MaterialConst_DensityBoussinesqGetField_compressibility(MaterialConst_DensityBoussinesq *point,double *data)
{
  *data = point->beta;
}


/* ===================================== */
/* Setters for MaterialConst_DensityBoussinesq */
/* ===================================== */
void MaterialConst_DensityBoussinesqSetField_density(MaterialConst_DensityBoussinesq *point,double data)
{
  point->density = data;
}

void MaterialConst_DensityBoussinesqSetField_thermalexpension(MaterialConst_DensityBoussinesq *point,double data)
{
  point->alpha = data;
}

void MaterialConst_DensityBoussinesqSetField_compressibility(MaterialConst_DensityBoussinesq *point,double data)
{
  point->beta = data;
}


/* ===================================== */
/* C-viewer for MaterialConst_DensityBoussinesq */
/* ===================================== */
void MaterialConst_DensityBoussinesqView(MaterialConst_DensityBoussinesq *point)
{
  {
    double data;
    MaterialConst_DensityBoussinesqGetField_density(point,&data);
    printf("field: density = %1.6e; [size %zu; type double; variable_name density]\n",data, MaterialConst_DensityBoussinesq_member_sizes[0] );
  }
  {
    double data;
    MaterialConst_DensityBoussinesqGetField_thermalexpension(point,&data);
    printf("field: thermalexpension = %1.6e; [size %zu; type double; variable_name alpha]\n",data, MaterialConst_DensityBoussinesq_member_sizes[1] );
  }
  {
    double data;
    MaterialConst_DensityBoussinesqGetField_compressibility(point,&data);
    printf("field: compressibility = %1.6e; [size %zu; type double; variable_name beta]\n",data, MaterialConst_DensityBoussinesq_member_sizes[2] );
  }
}


/* ===================================== */
/* VTK viewer for MaterialConst_DensityBoussinesq */
/* ===================================== */
void MaterialConst_DensityBoussinesqVTKWriteAsciiAllFields(FILE *vtk_fp,const int N,const MaterialConst_DensityBoussinesq points[])
{
  int p;
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"density\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].density);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"alpha\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].alpha);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"beta\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].beta);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
}


/* ===================================== */
/* PVTU viewer for MaterialConst_DensityBoussinesq */
/* ===================================== */
void MaterialConst_DensityBoussinesqPVTUWriteAllPPointDataFields(FILE *vtk_fp)
{
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"density\" NumberOfComponents=\"1\"/>\n");
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"alpha\" NumberOfComponents=\"1\"/>\n");
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"beta\" NumberOfComponents=\"1\"/>\n");
}


/* ===================================== */
/* VTK binary (appended header) viewer for MaterialConst_DensityBoussinesq */
/* ===================================== */
void MaterialConst_DensityBoussinesqVTKWriteBinaryAppendedHeaderAllFields(FILE *vtk_fp,int *offset,const int N,const MaterialConst_DensityBoussinesq points[])
{
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"density\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"alpha\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"beta\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

}


/* ================================================== */
/* VTK binary (appended data) viewer for MaterialConst_DensityBoussinesq */
/* ==================================================== */
void MaterialConst_DensityBoussinesqVTKWriteBinaryAppendedDataAllFields(FILE *vtk_fp,const int N,const MaterialConst_DensityBoussinesq points[])
{
  int p,length;
  size_t atomic_size;

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].density,atomic_size,1,vtk_fp);
  }

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].alpha,atomic_size,1,vtk_fp);
  }

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].beta,atomic_size,1,vtk_fp);
  }

}

