/*@ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 **
 **    Copyright (c) 2012
 **        Dave A. May [dave.may@erdw.ethz.ch]
 **        Institute of Geophysics
 **        ETH Zürich
 **        Sonneggstrasse 5
 **        CH-8092 Zürich
 **        Switzerland
 **
 **    project:    pTatin3d
 **    filename:   MaterialConst_SoftExpo_def.c
 **
 **
 **    pTatin3d is free software: you can redistribute it and/or modify
 **    it under the terms of the GNU General Public License as published
 **    by the Free Software Foundation, either version 3 of the License,
 **    or (at your option) any later version.
 **
 **    pTatin3d is distributed in the hope that it will be useful,
 **    but WITHOUT ANY WARRANTY; without even the implied warranty of
 **    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **    See the GNU General Public License for more details.
 **
 **    You should have received a copy of the GNU General Public License
 **    along with pTatin3d. If not, see <http://www.gnu.org/licenses/>.
 **
 ** ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ @*/
/*
  Auto generated by version 0.0 of swarm_class_generator.py
  on les-MacBook-Pro.local, at 2013-03-08 17:43:59.347412 by laetitia
*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "material_constants/MaterialConst_SoftExpo_def.h"


const char MaterialConst_SoftExpo_classname[] = "MaterialConst_SoftExpo";

const int MaterialConst_SoftExpo_nmembers = 2;

const size_t MaterialConst_SoftExpo_member_sizes[] = {
  1 * sizeof(double),
  1 * sizeof(double)
} ;

const char *MaterialConst_SoftExpo_member_names[] = {
  "eps_min",
  "eps_fold"
} ;


/* ===================================== */
/* Getters for MaterialConst_SoftExpo */
/* ===================================== */
void MaterialConst_SoftExpoGetField_eps_min(MaterialConst_SoftExpo *point,double *data)
{
  *data = point->eps_min;
}

void MaterialConst_SoftExpoGetField_eps_fold(MaterialConst_SoftExpo *point,double *data)
{
  *data = point->eps_fold;
}


/* ===================================== */
/* Setters for MaterialConst_SoftExpo */
/* ===================================== */
void MaterialConst_SoftExpoSetField_eps_min(MaterialConst_SoftExpo *point,double data)
{
  point->eps_min = data;
}

void MaterialConst_SoftExpoSetField_eps_fold(MaterialConst_SoftExpo *point,double data)
{
  point->eps_fold = data;
}


/* ===================================== */
/* C-viewer for MaterialConst_SoftExpo */
/* ===================================== */
void MaterialConst_SoftExpoView(MaterialConst_SoftExpo *point)
{
  {
    double data;
    MaterialConst_SoftExpoGetField_eps_min(point,&data);
    printf("field: eps_min = %1.6e; [size %zu; type double; variable_name eps_min]\n",data, MaterialConst_SoftExpo_member_sizes[0] );
  }
  {
    double data;
    MaterialConst_SoftExpoGetField_eps_fold(point,&data);
    printf("field: eps_fold = %1.6e; [size %zu; type double; variable_name eps_fold]\n",data, MaterialConst_SoftExpo_member_sizes[1] );
  }
}


/* ===================================== */
/* VTK viewer for MaterialConst_SoftExpo */
/* ===================================== */
void MaterialConst_SoftExpoVTKWriteAsciiAllFields(FILE *vtk_fp,const int N,const MaterialConst_SoftExpo points[])
{
  int p;
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"eps_min\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].eps_min);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"eps_fold\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].eps_fold);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
}


/* ===================================== */
/* PVTU viewer for MaterialConst_SoftExpo */
/* ===================================== */
void MaterialConst_SoftExpoPVTUWriteAllPPointDataFields(FILE *vtk_fp)
{
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"eps_min\" NumberOfComponents=\"1\"/>\n");
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"eps_fold\" NumberOfComponents=\"1\"/>\n");
}


/* ===================================== */
/* VTK binary (appended header) viewer for MaterialConst_SoftExpo */
/* ===================================== */
void MaterialConst_SoftExpoVTKWriteBinaryAppendedHeaderAllFields(FILE *vtk_fp,int *offset,const int N,const MaterialConst_SoftExpo points[])
{
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"eps_min\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"eps_fold\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

}


/* ================================================== */
/* VTK binary (appended data) viewer for MaterialConst_SoftExpo */
/* ==================================================== */
void MaterialConst_SoftExpoVTKWriteBinaryAppendedDataAllFields(FILE *vtk_fp,const int N,const MaterialConst_SoftExpo points[])
{
  int p,length;
  size_t atomic_size;

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].eps_min,atomic_size,1,vtk_fp);
  }

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].eps_fold,atomic_size,1,vtk_fp);
  }

}

