/*@ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 **
 **    Copyright (c) 2012
 **        Dave A. May [dave.may@erdw.ethz.ch]
 **        Institute of Geophysics
 **        ETH Zürich
 **        Sonneggstrasse 5
 **        CH-8092 Zürich
 **        Switzerland
 **
 **    project:    pTatin3d
 **    filename:   MaterialConst_ViscosityConst_def.c
 **
 **
 **    pTatin3d is free software: you can redistribute it and/or modify
 **    it under the terms of the GNU General Public License as published
 **    by the Free Software Foundation, either version 3 of the License,
 **    or (at your option) any later version.
 **
 **    pTatin3d is distributed in the hope that it will be useful,
 **    but WITHOUT ANY WARRANTY; without even the implied warranty of
 **    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **    See the GNU General Public License for more details.
 **
 **    You should have received a copy of the GNU General Public License
 **    along with pTatin3d. If not, see <http://www.gnu.org/licenses/>.
 **
 ** ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ @*/
/*
  Auto generated by version 0.0 of swarm_class_generator.py
  on les-MacBook-Pro.local, at 2013-03-08 17:43:59.343516 by laetitia
*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "material_constants/MaterialConst_ViscosityConst_def.h"


const char MaterialConst_ViscosityConst_classname[] = "MaterialConst_ViscosityConst";

const int MaterialConst_ViscosityConst_nmembers = 1;

const size_t MaterialConst_ViscosityConst_member_sizes[] = {
  1 * sizeof(double)
} ;

const char *MaterialConst_ViscosityConst_member_names[] = {
  "eta0"
} ;


/* ===================================== */
/* Getters for MaterialConst_ViscosityConst */
/* ===================================== */
void MaterialConst_ViscosityConstGetField_eta0(MaterialConst_ViscosityConst *point,double *data)
{
  *data = point->eta0;
}


/* ===================================== */
/* Setters for MaterialConst_ViscosityConst */
/* ===================================== */
void MaterialConst_ViscosityConstSetField_eta0(MaterialConst_ViscosityConst *point,double data)
{
  point->eta0 = data;
}


/* ===================================== */
/* C-viewer for MaterialConst_ViscosityConst */
/* ===================================== */
void MaterialConst_ViscosityConstView(MaterialConst_ViscosityConst *point)
{
  {
    double data;
    MaterialConst_ViscosityConstGetField_eta0(point,&data);
    printf("field: eta0 = %1.6e; [size %zu; type double; variable_name eta0]\n",data, MaterialConst_ViscosityConst_member_sizes[0] );
  }
}


/* ===================================== */
/* VTK viewer for MaterialConst_ViscosityConst */
/* ===================================== */
void MaterialConst_ViscosityConstVTKWriteAsciiAllFields(FILE *vtk_fp,const int N,const MaterialConst_ViscosityConst points[])
{
  int p;
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"eta0\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].eta0);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
}


/* ===================================== */
/* PVTU viewer for MaterialConst_ViscosityConst */
/* ===================================== */
void MaterialConst_ViscosityConstPVTUWriteAllPPointDataFields(FILE *vtk_fp)
{
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"eta0\" NumberOfComponents=\"1\"/>\n");
}


/* ===================================== */
/* VTK binary (appended header) viewer for MaterialConst_ViscosityConst */
/* ===================================== */
void MaterialConst_ViscosityConstVTKWriteBinaryAppendedHeaderAllFields(FILE *vtk_fp,int *offset,const int N,const MaterialConst_ViscosityConst points[])
{
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"eta0\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

}


/* ================================================== */
/* VTK binary (appended data) viewer for MaterialConst_ViscosityConst */
/* ==================================================== */
void MaterialConst_ViscosityConstVTKWriteBinaryAppendedDataAllFields(FILE *vtk_fp,const int N,const MaterialConst_ViscosityConst points[])
{
  int p,length;
  size_t atomic_size;

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].eta0,atomic_size,1,vtk_fp);
  }

}

