
##
##

import numpy as np
import matplotlib.cm as cm
import matplotlib.mlab as mlab
import matplotlib.pyplot as plt

from matplotlib import rc
#rc('font',**{'family':'sans-serif','sans-serif':['Helvetica']})
rc('font',**{'family':'serif','serif':['Times New Roman']})


from scipy import linspace, polyval, polyfit, sqrt, stats, randn, log10, power
import pylab
from pylab import figure, axes, plot, xlabel, ylabel, title, grid, savefig, legend, show

from numpy import *


rc('text', usetex=True) # seems to change the font used for the numbers, but not the labels


#params = {'backend': 'ps',
#           'axes.labelsize': 10,
#           'text.fontsize': 10,
#           'legend.fontsize': 10,
#           'xtick.labelsize': 8,
#           'ytick.labelsize': 8,
##           'text.usetex': True,
#           'figure.figsize': 250}
#pylab.rcParams.update(params)

#### INSERT OUTPUT FROM filer-snes-vp2.py HERE ##########
#=== Filtering  sinker48.deformed.loworder.log ===
# KSP Component U,V,W,P
FC_res_a=array([
[0,0,0.000000000000e+00,2.186659379386e-03,0.000000000000e+00,0.000000000000e+00],
[1,28,6.287349359009e-11,2.186646782701e-03,1.204477772341e-10,5.248285554003e-06],
[2,42,5.468301064929e-08,2.185114110183e-03,5.595387035248e-08,5.810826436132e-05],
[3,52,5.757519733437e-07,2.180615255605e-03,5.855194934889e-07,1.147983252256e-04],
[4,61,1.722414913843e-05,2.040363829753e-03,1.785483177798e-05,5.454381502077e-04],
[5,72,2.341816288432e-05,1.871154423021e-03,2.383284253691e-05,7.669726850963e-04],
[6,81,3.619399725311e-05,1.636294453874e-03,3.766860515079e-05,9.465943260340e-04],
[7,90,2.547266133359e-05,1.410051209367e-03,2.662874395153e-05,1.045075515112e-03],
[8,99,6.254917997684e-05,8.987298067260e-04,6.687651842256e-05,1.069126643579e-03],
[9,107,1.439398456020e-04,5.798515961903e-04,1.412067381022e-04,9.214078410652e-04],
[10,116,8.996337669628e-05,3.047351635780e-04,9.009146164593e-05,7.073411595584e-04],
[11,125,3.913839842238e-05,1.536963522596e-04,4.056931680529e-05,4.939872983947e-04],
[12,134,3.981285921995e-05,1.243038649930e-04,4.037942448645e-05,3.847168838921e-04],
[13,143,4.797756053057e-05,1.307211780557e-04,4.938758387888e-05,3.021532394084e-04],
[14,152,5.454676686897e-05,1.411842303464e-04,5.494334648515e-05,2.626811310493e-04],
[15,161,6.653924657098e-05,1.673764980159e-04,6.702096041533e-05,1.890938510207e-04],
[16,172,6.469300966315e-05,1.614969595194e-04,6.548757367681e-05,1.342255204315e-04],
[17,184,5.302292838750e-05,1.312589903335e-04,5.334218268632e-05,1.387168743678e-04],
[18,192,4.911131843604e-05,1.098299560535e-04,4.984652958243e-05,1.281338241250e-04],
[19,200,2.869777881761e-05,6.407788845943e-05,3.018583072745e-05,1.254593518784e-04],
[20,208,1.638611747287e-05,2.606814055048e-05,1.955238091379e-05,1.021052628596e-04],
[21,216,9.825875967651e-06,1.463078477692e-05,1.258495906481e-05,7.755204773160e-05],
[22,224,9.088178890512e-06,1.153350984018e-05,1.223037449383e-05,6.690924160584e-05],
[23,232,8.181992531102e-06,1.268038674737e-05,1.111701863000e-05,4.762673663450e-05],
[24,240,7.469842268434e-06,9.952228454513e-06,1.053601469770e-05,3.645105345751e-05],
[25,248,5.952417795794e-06,5.903332723550e-06,9.382589162804e-06,2.697993517698e-05],
[26,256,5.039843705732e-06,3.769744691872e-06,8.602901432184e-06,2.077985448706e-05],
[27,263,5.395197737073e-06,4.737044792389e-06,8.728448017492e-06,1.852778148234e-05],
[28,271,5.669884961559e-06,5.734219068498e-06,8.756324952890e-06,1.520156690528e-05],
[29,278,5.834374046930e-06,6.173100789229e-06,8.923963308884e-06,1.189407691943e-05],
[30,286,5.848652472885e-06,5.763325887353e-06,8.953069522916e-06,1.116069326656e-05],
[31,305,5.537571250594e-06,5.417128571030e-06,8.499444074109e-06,1.151422268626e-05],
[32,314,4.105327394003e-06,4.837914645331e-06,5.743890943100e-06,1.206227723994e-05],
[33,322,3.065053287054e-06,4.005625590318e-06,3.659748159753e-06,1.117182278028e-05],
[34,330,1.781986131673e-06,2.544646779414e-06,1.915832112222e-06,1.088593531658e-05],
[35,339,2.055428667999e-06,2.391282359652e-06,2.303014441383e-06,9.228029966948e-06],
[36,347,2.120357938432e-06,2.350876276265e-06,2.682820804803e-06,8.055364928637e-06],
[37,354,2.331114528329e-06,2.570789100403e-06,3.158542398509e-06,7.387270359570e-06],
[38,363,2.235213116003e-06,2.365721782322e-06,3.117938094697e-06,6.747161820575e-06],
[39,371,1.839197210828e-06,1.839355835855e-06,2.445338441244e-06,6.113866091590e-06],
[40,379,1.104409912641e-06,1.218919261372e-06,1.594365327560e-06,5.179672467945e-06],
[41,386,9.412351818510e-07,1.166617855474e-06,1.074175198579e-06,4.315375892790e-06],
[42,393,4.370887457189e-07,4.879315992182e-07,4.949998720723e-07,2.863320342348e-06],
[43,400,3.935950971303e-07,4.596374587256e-07,4.093610184864e-07,2.422117021623e-06],
[44,408,3.316095269475e-07,3.801839095790e-07,3.175311988501e-07,1.993584090763e-06],
[45,416,2.081589014966e-07,2.145475797183e-07,2.178091807220e-07,1.668987784242e-06],
[46,424,1.361292010681e-07,1.681183616277e-07,1.537712991573e-07,1.248650877753e-06],
[47,432,1.041065842727e-07,1.399185981101e-07,1.102256235136e-07,1.086725664302e-06],
[48,440,1.094303698000e-07,1.352013685467e-07,1.215423503663e-07,9.358958904170e-07],
])


max_FC_iterations_with_KSP = 48
FCiteration_a = [0]*max_FC_iterations_with_KSP


FCiteration_a[0]=array([
[0,0,1.000000000000e+00],
[1,1,9.973305628421e-01],
[2,2,9.971528393709e-01],
[3,3,9.952499714297e-01],
[4,4,9.882234548570e-01],
[5,5,9.879181032895e-01],
[6,6,9.773013771397e-01],
[7,7,9.456592533854e-01],
[8,8,9.253395720213e-01],
[9,9,8.819184347899e-01],
[10,10,8.528967692144e-01],
[11,11,8.051447317243e-01],
[12,12,7.138808343788e-01],
[13,13,5.372092228859e-01],
[14,14,3.567177393669e-01],
[15,15,2.122937204713e-01],
[16,16,1.350283095426e-01],
[17,17,8.198923390995e-02],
[18,18,5.663762786781e-02],
[19,19,3.702890708069e-02],
[20,20,2.342477080677e-02],
[21,21,1.549190085753e-02],
[22,22,1.207932884845e-02],
[23,23,1.138566121837e-02],
[24,24,1.134306324535e-02],
[25,25,1.118696635625e-02],
[26,26,1.042457853066e-02],
[27,27,9.703707926338e-03],
])
FCiteration_a[1]=array([
[28,0,1.484479245341e-02],
[29,1,1.484479205189e-02],
[30,2,1.484479177598e-02],
[31,3,1.455540497111e-02],
[32,4,1.455116401309e-02],
[33,5,1.107922764300e-02],
[34,6,4.798361032913e-03],
[35,7,2.992686868430e-03],
[36,8,2.050092040069e-03],
[37,9,1.208844077931e-03],
[38,10,6.424105764352e-04],
[39,11,3.395357076539e-04],
[40,12,2.088928830431e-04],
[41,13,1.370322591465e-04],
])
FCiteration_a[2]=array([
[42,0,2.979750614580e-01],
[43,1,2.850046246302e-01],
[44,2,8.931519342304e-02],
[45,3,5.127938698647e-02],
[46,4,3.948903558980e-02],
[47,5,2.205535486755e-02],
[48,6,1.445472916186e-02],
[49,7,1.072310573611e-02],
[50,8,5.222910966327e-03],
[51,9,2.196909192200e-03],
])
FCiteration_a[3]=array([
[52,0,1.583542828707e+00],
[53,1,1.265073435292e+00],
[54,2,3.843941296621e-01],
[55,3,1.240563647795e-01],
[56,4,1.189588286988e-01],
[57,5,6.424323595980e-02],
[58,6,3.625457977259e-02],
[59,7,1.747526435105e-02],
[60,8,1.004383053976e-02],
])
FCiteration_a[4]=array([
[61,0,5.033112953603e+00],
[62,1,4.585940441436e+00],
[63,2,1.547709619433e+00],
[64,3,5.702508070764e-01],
[65,4,5.352245122561e-01],
[66,5,2.676927990358e-01],
[67,6,1.678168923925e-01],
[68,7,8.695323341765e-02],
[69,8,6.093251619788e-02],
[70,9,5.215351706822e-02],
[71,10,4.376838002607e-02],
])
FCiteration_a[5]=array([
[72,0,7.677229084414e+00],
[73,1,6.282504011286e+00],
[74,2,1.753951743302e+00],
[75,3,5.996486243891e-01],
[76,4,5.943992189463e-01],
[77,5,3.391552798536e-01],
[78,6,2.012501278293e-01],
[79,7,9.474390920988e-02],
[80,8,4.973311948712e-02],
])
FCiteration_a[6]=array([
[81,0,1.298752050332e+01],
[82,1,1.161191220442e+01],
[83,2,2.355778955727e+00],
[84,3,8.005061825667e-01],
[85,4,7.858810424004e-01],
[86,5,5.135735388632e-01],
[87,6,3.097321926048e-01],
[88,7,1.418514941006e-01],
[89,8,6.311223093935e-02],
])
FCiteration_a[7]=array([
[90,0,1.429729427660e+01],
[91,1,7.223698718077e+00],
[92,2,2.321526806147e+00],
[93,3,8.996413161599e-01],
[94,4,8.229736852166e-01],
[95,5,5.684949709142e-01],
[96,6,3.329385698763e-01],
[97,7,1.475099094076e-01],
[98,8,6.244594279314e-02],
])
FCiteration_a[8]=array([
[99,0,2.675572190406e+01],
[100,1,2.472390204473e+01],
[101,2,4.228062214889e+00],
[102,3,2.413504772089e+00],
[103,4,1.631776782474e+00],
[104,5,1.169891211800e+00],
[105,6,6.377680862397e-01],
[106,7,2.611266247125e-01],
])
FCiteration_a[9]=array([
[107,0,2.732736270600e+01],
[108,1,1.076435302659e+01],
[109,2,4.189042397280e+00],
[110,3,1.708794298229e+00],
[111,4,1.706122775352e+00],
[112,5,1.252887856846e+00],
[113,6,6.689847551903e-01],
[114,7,2.744924028598e-01],
[115,8,1.197907332910e-01],
])
FCiteration_a[10]=array([
[116,0,3.635054881131e+01],
[117,1,3.351496482901e+01],
[118,2,6.104540693441e+00],
[119,3,4.111746795413e+00],
[120,4,2.725453606682e+00],
[121,5,2.031955656693e+00],
[122,6,9.780512914284e-01],
[123,7,3.717001629452e-01],
[124,8,1.810362102292e-01],
])
FCiteration_a[11]=array([
[125,0,4.240055893395e+01],
[126,1,3.953324372956e+01],
[127,2,7.764215407452e+00],
[128,3,3.690866826479e+00],
[129,4,3.322902915319e+00],
[130,5,2.404687125671e+00],
[131,6,1.150042117062e+00],
[132,7,4.245175964206e-01],
[133,8,2.401364282640e-01],
])
FCiteration_a[12]=array([
[134,0,4.610273360454e+01],
[135,1,4.390959189387e+01],
[136,2,9.317590676888e+00],
[137,3,4.981429498804e+00],
[138,4,3.961319040243e+00],
[139,5,2.807241452836e+00],
[140,6,1.348168400851e+00],
[141,7,4.932113044247e-01],
[142,8,3.051131484336e-01],
])
FCiteration_a[13]=array([
[143,0,4.980957397210e+01],
[144,1,4.879618315118e+01],
[145,2,1.130457137119e+01],
[146,3,8.435752933034e+00],
[147,4,4.611377868856e+00],
[148,5,3.080507057999e+00],
[149,6,1.577504174933e+00],
[150,7,6.043387555493e-01],
[151,8,3.926903840157e-01],
])
FCiteration_a[14]=array([
[152,0,5.953159324155e+01],
[153,1,5.809028755498e+01],
[154,2,1.275731299325e+01],
[155,3,9.239023369312e+00],
[156,4,5.334477468561e+00],
[157,5,3.739193964632e+00],
[158,6,1.897920931290e+00],
[159,7,6.720462536210e-01],
[160,8,4.126886690115e-01],
])
FCiteration_a[15]=array([
[161,0,4.322170941914e+01],
[162,1,4.276749573324e+01],
[163,2,1.582364187699e+01],
[164,3,1.163631501522e+01],
[165,4,6.250289753367e+00],
[166,5,3.275555780033e+00],
[167,6,1.721101950807e+00],
[168,7,8.093296902720e-01],
[169,8,5.843488852695e-01],
[170,9,5.239705768244e-01],
[171,10,4.260011789356e-01],
])
FCiteration_a[16]=array([
[172,0,2.752324586273e+01],
[173,1,2.712970266872e+01],
[174,2,1.119961258146e+01],
[175,3,6.053779497024e+00],
[176,4,4.493552349686e+00],
[177,5,2.257341407237e+00],
[178,6,1.177405772299e+00],
[179,7,5.822602456787e-01],
[180,8,4.250369635633e-01],
[181,9,3.795943070783e-01],
[182,10,2.992244701799e-01],
[183,11,1.841635860422e-01],
])
FCiteration_a[17]=array([
[184,0,4.787390908919e+01],
[185,1,4.702130666406e+01],
[186,2,7.891317914515e+00],
[187,3,6.563718782453e+00],
[188,4,3.967294477974e+00],
[189,5,3.281045462888e+00],
[190,6,1.482564006415e+00],
[191,7,4.215049694153e-01],
])
FCiteration_a[18]=array([
[192,0,5.249999195455e+01],
[193,1,5.120010780763e+01],
[194,2,8.041814427277e+00],
[195,3,5.564086725023e+00],
[196,4,3.831720575171e+00],
[197,5,3.158270640047e+00],
[198,6,1.592735602611e+00],
[199,7,4.840682961029e-01],
])
FCiteration_a[19]=array([
[200,0,3.788242168051e+01],
[201,1,3.697154217557e+01],
[202,2,6.819058329565e+00],
[203,3,5.461079630392e+00],
[204,4,2.292352681877e+00],
[205,5,1.300022313263e+00],
[206,6,7.888067860772e-01],
[207,7,3.464518100303e-01],
])
FCiteration_a[20]=array([
[208,0,5.566922822572e+01],
[209,1,5.524897138447e+01],
[210,2,6.839501466393e+00],
[211,3,5.647967053830e+00],
[212,4,2.105741598513e+00],
[213,5,1.405284581233e+00],
[214,6,9.488551978491e-01],
[215,7,4.299884642070e-01],
])
FCiteration_a[21]=array([
[216,0,6.122452830388e+01],
[217,1,6.047404673511e+01],
[218,2,7.939780072875e+00],
[219,3,7.243013033836e+00],
[220,4,2.732448627969e+00],
[221,5,1.881407584978e+00],
[222,6,1.189447933401e+00],
[223,7,4.694719466044e-01],
])
FCiteration_a[22]=array([
[224,0,7.407723026255e+01],
[225,1,7.307730494039e+01],
[226,2,9.331188309047e+00],
[227,3,5.851088401209e+00],
[228,4,3.058784516577e+00],
[229,5,2.019441699437e+00],
[230,6,1.313947406567e+00],
[231,7,5.286526535994e-01],
])
FCiteration_a[23]=array([
[232,0,5.512264999950e+01],
[233,1,5.492325588760e+01],
[234,2,5.482891642563e+00],
[235,3,5.283359725090e+00],
[236,4,1.526293462284e+00],
[237,5,9.527585460482e-01],
[238,6,6.393995519584e-01],
[239,7,3.302169116954e-01],
])
FCiteration_a[24]=array([
[240,0,7.698328152628e+01],
[241,1,7.666628558350e+01],
[242,2,7.524495681697e+00],
[243,3,7.217846439252e+00],
[244,4,2.063746790406e+00],
[245,5,1.235134159962e+00],
[246,6,8.104648267893e-01],
[247,7,3.967079557696e-01],
])
FCiteration_a[25]=array([
[248,0,7.704495464709e+01],
[249,1,7.680939500831e+01],
[250,2,7.904520358276e+00],
[251,3,7.637984068605e+00],
[252,4,2.132464346423e+00],
[253,5,1.179595824844e+00],
[254,6,7.800628223257e-01],
[255,7,4.252390564387e-01],
])
FCiteration_a[26]=array([
[256,0,7.254290013667e+01],
[257,1,7.242635059567e+01],
[258,2,7.811306682624e+00],
[259,3,7.738590467092e+00],
[260,4,2.078230127041e+00],
[261,5,9.958359963462e-01],
[262,6,6.527265014106e-01],
])
FCiteration_a[27]=array([
[263,0,6.692691040837e+01],
[264,1,6.664399803071e+01],
[265,2,9.225268827446e+00],
[266,3,8.831688557104e+00],
[267,4,2.720523127031e+00],
[268,5,1.324538506626e+00],
[269,6,8.454770284131e-01],
[270,7,4.154228880273e-01],
])
FCiteration_a[28]=array([
[271,0,8.130815492933e+01],
[272,1,8.104792691739e+01],
[273,2,9.144560632442e+00],
[274,3,8.880771026307e+00],
[275,4,2.195002134734e+00],
[276,5,8.499280999473e-01],
[277,6,4.321430908800e-01],
])
FCiteration_a[29]=array([
[278,0,7.095547706832e+01],
[279,1,7.081838367091e+01],
[280,2,8.392177790176e+00],
[281,3,8.230877861390e+00],
[282,4,2.122134673439e+00],
[283,5,1.120141418552e+00],
[284,6,7.551272008397e-01],
[285,7,4.631718009285e-01],
])
FCiteration_a[30]=array([
[286,0,1.693165147102e+01],
[287,1,1.693135126430e+01],
[288,2,2.170571696438e+00],
[289,3,2.143257405756e+00],
[290,4,9.064915185449e-01],
[291,5,7.289965904124e-01],
[292,6,6.265028062214e-01],
[293,7,5.558614521555e-01],
[294,8,5.385845774167e-01],
[295,9,5.360528395368e-01],
[296,10,5.336810632117e-01],
[297,11,5.266401079347e-01],
[298,12,5.113395191344e-01],
[299,13,4.706061329750e-01],
[300,14,3.752120582804e-01],
[301,15,2.902522136257e-01],
[302,16,2.517572204359e-01],
[303,17,2.092963022176e-01],
[304,18,1.393492555410e-01],
])
FCiteration_a[31]=array([
[305,0,9.855851931023e+00],
[306,1,9.853329451722e+00],
[307,2,1.192197302260e+00],
[308,3,1.185738755051e+00],
[309,4,3.698020042268e-01],
[310,5,2.435858654393e-01],
[311,6,1.789942260963e-01],
[312,7,1.166492356603e-01],
[313,8,9.060150648120e-02],
])
FCiteration_a[32]=array([
[314,0,4.945997443378e+01],
[315,1,4.943647143065e+01],
[316,2,5.937365242937e+00],
[317,3,5.891098261578e+00],
[318,4,1.785172995607e+00],
[319,5,1.155422504902e+00],
[320,6,8.195563394161e-01],
[321,7,4.853399759311e-01],
])
FCiteration_a[33]=array([
[322,0,8.953883310348e+01],
[323,1,8.922819807789e+01],
[324,2,1.067753029289e+01],
[325,3,1.033898361268e+01],
[326,4,2.998574342421e+00],
[327,5,1.798799596436e+00],
[328,6,1.242580970167e+00],
[329,7,6.622650932540e-01],
])
FCiteration_a[34]=array([
[330,0,4.051095339320e+01],
[331,1,4.049997797456e+01],
[332,2,4.908611882502e+00],
[333,3,4.885119133902e+00],
[334,4,1.326683070126e+00],
[335,5,7.768423788719e-01],
[336,6,5.793380226966e-01],
[337,7,4.296167536196e-01],
[338,8,3.495865252486e-01],
])
FCiteration_a[35]=array([
[339,0,6.949577653245e+01],
[340,1,6.945075376052e+01],
[341,2,8.870648668207e+00],
[342,3,8.754537219487e+00],
[343,4,2.296384813320e+00],
[344,5,1.260321902631e+00],
[345,6,8.931305935562e-01],
[346,7,5.977055845734e-01],
])
FCiteration_a[36]=array([
[347,0,5.635297801725e+01],
[348,1,5.630518926348e+01],
[349,2,7.573783621820e+00],
[350,3,7.487586724029e+00],
[351,4,1.816368132657e+00],
[352,5,8.442656584664e-01],
[353,6,5.316828410493e-01],
])
FCiteration_a[37]=array([
[354,0,3.569277502050e+01],
[355,1,3.568140202249e+01],
[356,2,4.428517697493e+00],
[357,3,4.406946506989e+00],
[358,4,1.281157047729e+00],
[359,5,8.717083236198e-01],
[360,6,6.091512932165e-01],
[361,7,3.742141462696e-01],
[362,8,2.938951398924e-01],
])
FCiteration_a[38]=array([
[363,0,6.663773305725e+01],
[364,1,6.634491862269e+01],
[365,2,7.850928058950e+00],
[366,3,7.520097080717e+00],
[367,4,2.193920153823e+00],
[368,5,1.493009444223e+00],
[369,6,9.540726608690e-01],
[370,7,4.141943804243e-01],
])
FCiteration_a[39]=array([
[371,0,7.668350367366e+01],
[372,1,6.997604371636e+01],
[373,2,8.969668992572e+00],
[374,3,5.310684192354e+00],
[375,4,2.397672790338e+00],
[376,5,1.580505773130e+00],
[377,6,1.026348740792e+00],
[378,7,4.230312161148e-01],
])
FCiteration_a[40]=array([
[379,0,4.059202536816e+01],
[380,1,3.987280734041e+01],
[381,2,4.488775231852e+00],
[382,3,3.954194994159e+00],
[383,4,9.988219127821e-01],
[384,5,5.115023319270e-01],
[385,6,3.515771140370e-01],
])
FCiteration_a[41]=array([
[386,0,5.991149408101e+01],
[387,1,5.969931390658e+01],
[388,2,7.662262649960e+00],
[389,3,7.292460148663e+00],
[390,4,1.579069443156e+00],
[391,5,6.318958589235e-01],
[392,6,3.433073820099e-01],
])
FCiteration_a[42]=array([
[393,0,8.038120836187e+01],
[394,1,7.039251721640e+01],
[395,2,8.901789534969e+00],
[396,3,4.990871489589e+00],
[397,4,2.058137052558e+00],
[398,5,1.123265915337e+00],
[399,6,7.779413790553e-01],
])
FCiteration_a[43]=array([
[400,0,3.884571733448e+01],
[401,1,3.839437924707e+01],
[402,2,4.245543804291e+00],
[403,3,3.932366837679e+00],
[404,4,1.133592088431e+00],
[405,5,6.742879698165e-01],
[406,6,4.713646140826e-01],
[407,7,2.248108206893e-01],
])
FCiteration_a[44]=array([
[408,0,5.743263619086e+01],
[409,1,5.290614632342e+01],
[410,2,6.462889220540e+00],
[411,3,4.063416700555e+00],
[412,4,1.968100287396e+00],
[413,5,1.309795603255e+00],
[414,6,8.681400079964e-01],
[415,7,3.497681764811e-01],
])
FCiteration_a[45]=array([
[416,0,8.713071754987e+01],
[417,1,8.088999969008e+01],
[418,2,9.451225245376e+00],
[419,3,6.791569675395e+00],
[420,4,2.954115778545e+00],
[421,5,2.003922865854e+00],
[422,6,1.360670530853e+00],
[423,7,5.448076541670e-01],
])
FCiteration_a[46]=array([
[424,0,4.891852231526e+01],
[425,1,4.734955173353e+01],
[426,2,5.638314412365e+00],
[427,3,4.411214764572e+00],
[428,4,1.832276874515e+00],
[429,5,1.319240937782e+00],
[430,6,8.604072379784e-01],
[431,7,3.177250201188e-01],
])
FCiteration_a[47]=array([
[432,0,8.017932133397e+01],
[433,1,7.938318953993e+01],
[434,2,9.175024049791e+00],
[435,3,3.888011890626e+00],
[436,4,2.805001136761e+00],
[437,5,2.029634979844e+00],
[438,6,1.334426056939e+00],
[439,7,4.946731918466e-01],
])



#### FINISH DATA HERE ##########



FC_res_at = FC_res_a.transpose()
y = array(["%1.8e" % w for w in FC_res_at.reshape(FC_res_at.size)])
FC_res = y.reshape(FC_res_at.shape)


FCiteration_at = [0]*max_FC_iterations_with_KSP
FCiteration    = [0]*max_FC_iterations_with_KSP

for k in range(0,max_FC_iterations_with_KSP):
	FCiteration_at[k] = FCiteration_a[k].transpose()
	y = array(["%1.8e" % w for w in FCiteration_at[k].reshape(FCiteration_at[k].size)])
	FCiteration[k] = y.reshape(FCiteration_at[k].shape)


fig = plt.figure()


## figure 1, yaxis 1
ax1 = fig.add_subplot(111)
ax1.set_ylabel("$\|r\|_2$")
ax1.set_xlabel('Number of V-cycles')



## figure 1, xaxis 2
for k in range(0,max_FC_iterations_with_KSP):
	ax1.semilogy(FCiteration[k][0],FCiteration[k][2],color='0.7',linewidth=1.0, linestyle='-',marker='x')

ax1.semilogy(FC_res[1],FC_res[2],color='0.45',linewidth=1.0, linestyle='None',marker='o' )
ax1.semilogy(FC_res[1],FC_res[2],color='red',linewidth=5.0, linestyle='-',marker='None', label='$r_u$')

ax1.semilogy(FC_res[1],FC_res[3],color='0.45',linewidth=1.0, linestyle='None',marker='o' )
ax1.semilogy(FC_res[1],FC_res[3],color='green',linewidth=3.0, linestyle='-',marker='None', label='$r_v$')

ax1.semilogy(FC_res[1],FC_res[4],color='0.45',linewidth=1.0, linestyle='None',marker='o')
ax1.semilogy(FC_res[1],FC_res[4],color='blue',linewidth=3.0, linestyle='-',marker='None', label='$r_w$')

ax1.semilogy(FC_res[1],FC_res[5],color='0.45',linewidth=1.0, linestyle='None',marker='o')
ax1.semilogy(FC_res[1],FC_res[5],color='orange',linewidth=3.0, linestyle='-',marker='None', label='$r_p$')

#
# possibly the legend location needs to be adjusted
# loc = { 2 , 1 , 4, 3 }
#     = { top left , top right , bottom right , bottom left
#
leg = plt.legend( loc=4, numpoints=2, handletextpad=0)

plt.savefig("test.pdf")




