/*@ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 **
 **    Copyright (c) 2012
 **        Dave A. May [dave.may@erdw.ethz.ch]
 **        Institute of Geophysics
 **        ETH Zürich
 **        Sonneggstrasse 5
 **        CH-8092 Zürich
 **        Switzerland
 **
 **    project:    pTatin3d
 **    filename:   MPntStd_def.h
 **
 **
 **    pTatin3d is free software: you can redistribute it and/or modify
 **    it under the terms of the GNU General Public License as published
 **    by the Free Software Foundation, either version 3 of the License,
 **    or (at your option) any later version.
 **
 **    pTatin3d is distributed in the hope that it will be useful,
 **    but WITHOUT ANY WARRANTY; without even the implied warranty of
 **    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **    See the GNU General Public License for more details.
 **
 **    You should have received a copy of the GNU General Public License
 **    along with pTatin3d. If not, see <http://www.gnu.org/licenses/>.
 **
 ** ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ @*/



/*
  Auto generated by version 0.0 of swarm_class_generator.py
  on otsu.local, at 2012-02-13 00:08:18.105871 by dmay
*/


#ifndef __MPntStd_DEF_H__
#define __MPntStd_DEF_H__

typedef struct {
  long int pid ;
  double coor [ 3 ] ;
  double xi [ 3 ] ;
  int phase ;
  int wil ;
} MPntStd ;


typedef enum {
  MPStd_point_index = 0,
  MPStd_global_coord,
  MPStd_local_coord,
  MPStd_phase_index,
  MPStd_local_element_index
} MPntStdTypeName ;


extern const char MPntStd_classname[];

extern const int MPntStd_nmembers;

extern const size_t MPntStd_member_sizes[];

extern const char *MPntStd_member_names[];

/* prototypes */
void MPntStdGetField_point_index(MPntStd *point,long int *data);
void MPntStdGetField_global_coord(MPntStd *point,double *data[]);
void MPntStdGetField_local_coord(MPntStd *point,double *data[]);
void MPntStdGetField_phase_index(MPntStd *point,int *data);
void MPntStdGetField_local_element_index(MPntStd *point,int *data);
void MPntStdSetField_point_index(MPntStd *point,long int data);
void MPntStdSetField_global_coord(MPntStd *point,double data[]);
void MPntStdSetField_local_coord(MPntStd *point,double data[]);
void MPntStdSetField_phase_index(MPntStd *point,int data);
void MPntStdSetField_local_element_index(MPntStd *point,int data);
void MPntStdView(MPntStd *point);
void MPntStdVTKWriteAsciiAllFields(FILE *vtk_fp,const int N,const MPntStd points[]);
void MPntStdPVTUWriteAllPPointDataFields(FILE *vtk_fp);
void MPntStdVTKWriteBinaryAppendedHeaderAllFields(FILE *vtk_fp,int *offset,const int N,const MPntStd points[]);
void MPntStdVTKWriteBinaryAppendedDataAllFields(FILE *vtk_fp,const int N,const MPntStd points[]);

#endif
