/*@ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 **
 **    Copyright (c) 2012
 **        Dave A. May [dave.may@erdw.ethz.ch]
 **        Institute of Geophysics
 **        ETH Zürich
 **        Sonneggstrasse 5
 **        CH-8092 Zürich
 **        Switzerland
 **
 **    project:    pTatin3d
 **    filename:   QPntVolCoefStokes_def.h
 **
 **
 **    pTatin3d is free software: you can redistribute it and/or modify
 **    it under the terms of the GNU General Public License as published
 **    by the Free Software Foundation, either version 3 of the License,
 **    or (at your option) any later version.
 **
 **    pTatin3d is distributed in the hope that it will be useful,
 **    but WITHOUT ANY WARRANTY; without even the implied warranty of
 **    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **    See the GNU General Public License for more details.
 **
 **    You should have received a copy of the GNU General Public License
 **    along with pTatin3d. If not, see <http://www.gnu.org/licenses/>.
 **
 ** ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ @*/



/*
  Auto generated by version 0.0 of swarm_class_generator.py
  on geop-043.ethz.ch, at 2012-02-14 21:01:55.587101 by dmay
*/


#ifndef __QPntVolCoefStokes_DEF_H__
#define __QPntVolCoefStokes_DEF_H__

typedef struct {
  double eta ;
  double rho ;
  double Fu [ 3 ] ;
  double Fp ;
} QPntVolCoefStokes ;


typedef enum {
  QPVCStk_eta_effective = 0,
  QPVCStk_rho_effective,
  QPVCStk_momentum_rhs,
  QPVCStk_continuity_rhs
} QPntVolCoefStokesTypeName ;


extern const char QPntVolCoefStokes_classname[];

extern const int QPntVolCoefStokes_nmembers;

extern const size_t QPntVolCoefStokes_member_sizes[];

extern const char *QPntVolCoefStokes_member_names[];

/* prototypes */
void QPntVolCoefStokesGetField_eta_effective(QPntVolCoefStokes *point,double *data);
void QPntVolCoefStokesGetField_rho_effective(QPntVolCoefStokes *point,double *data);
void QPntVolCoefStokesGetField_momentum_rhs(QPntVolCoefStokes *point,double *data[]);
void QPntVolCoefStokesGetField_continuity_rhs(QPntVolCoefStokes *point,double *data);
void QPntVolCoefStokesSetField_eta_effective(QPntVolCoefStokes *point,double data);
void QPntVolCoefStokesSetField_rho_effective(QPntVolCoefStokes *point,double data);
void QPntVolCoefStokesSetField_momentum_rhs(QPntVolCoefStokes *point,double data[]);
void QPntVolCoefStokesSetField_continuity_rhs(QPntVolCoefStokes *point,double data);
void QPntVolCoefStokesView(QPntVolCoefStokes *point);
void QPntVolCoefStokesVTKWriteAsciiAllFields(FILE *vtk_fp,const int N,const QPntVolCoefStokes points[]);
void QPntVolCoefStokesPVTUWriteAllPPointDataFields(FILE *vtk_fp);
void QPntVolCoefStokesVTKWriteBinaryAppendedHeaderAllFields(FILE *vtk_fp,int *offset,const int N,const QPntVolCoefStokes points[]);
void QPntVolCoefStokesVTKWriteBinaryAppendedDataAllFields(FILE *vtk_fp,const int N,const QPntVolCoefStokes points[]);

#endif
