/*@ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 **
 **    Copyright (c) 2012
 **        Dave A. May [dave.may@erdw.ethz.ch]
 **        Institute of Geophysics
 **        ETH Zürich
 **        Sonneggstrasse 5
 **        CH-8092 Zürich
 **        Switzerland
 **
 **    project:    pTatin3d
 **    filename:   MPntPEnergy_def.c
 **
 **
 **    pTatin3d is free software: you can redistribute it and/or modify
 **    it under the terms of the GNU General Public License as published
 **    by the Free Software Foundation, either version 3 of the License,
 **    or (at your option) any later version.
 **
 **    pTatin3d is distributed in the hope that it will be useful,
 **    but WITHOUT ANY WARRANTY; without even the implied warranty of
 **    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **    See the GNU General Public License for more details.
 **
 **    You should have received a copy of the GNU General Public License
 **    along with pTatin3d. If not, see <http://www.gnu.org/licenses/>.
 **
 ** ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ @*/
/*
  Auto generated by version 0.0 of swarm_class_generator.py
  on otsu.local, at 2013-02-02 20:59:58.576148 by dmay
*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "MPntPEnergy_def.h"


const char MPntPEnergy_classname[] = "MPntPEnergy";

const int MPntPEnergy_nmembers = 2;

const size_t MPntPEnergy_member_sizes[] = {
  1 * sizeof(double),
  1 * sizeof(double)
} ;

const char *MPntPEnergy_member_names[] = {
  "diffusivity",
  "heat_source"
} ;


/* ===================================== */
/* Getters for MPntPEnergy */
/* ===================================== */
void MPntPEnergyGetField_diffusivity(MPntPEnergy *point,double *data)
{
  *data = point->diffusivity;
}

void MPntPEnergyGetField_heat_source(MPntPEnergy *point,double *data)
{
  *data = point->heat_source;
}


/* ===================================== */
/* Setters for MPntPEnergy */
/* ===================================== */
void MPntPEnergySetField_diffusivity(MPntPEnergy *point,double data)
{
  point->diffusivity = data;
}

void MPntPEnergySetField_heat_source(MPntPEnergy *point,double data)
{
  point->heat_source = data;
}


/* ===================================== */
/* C-viewer for MPntPEnergy */
/* ===================================== */
void MPntPEnergyView(MPntPEnergy *point)
{
  {
    double data;
    MPntPEnergyGetField_diffusivity(point,&data);
    printf("field: diffusivity = %1.6e; [size %zu; type double; variable_name diffusivity]\n",data, MPntPEnergy_member_sizes[0] );
  }
  {
    double data;
    MPntPEnergyGetField_heat_source(point,&data);
    printf("field: heat_source = %1.6e; [size %zu; type double; variable_name heat_source]\n",data, MPntPEnergy_member_sizes[1] );
  }
}


/* ===================================== */
/* VTK viewer for MPntPEnergy */
/* ===================================== */
void MPntPEnergyVTKWriteAsciiAllFields(FILE *vtk_fp,const int N,const MPntPEnergy points[])
{
  int p;
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"diffusivity\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].diffusivity);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"heat_source\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].heat_source);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
}


/* ===================================== */
/* PVTU viewer for MPntPEnergy */
/* ===================================== */
void MPntPEnergyPVTUWriteAllPPointDataFields(FILE *vtk_fp)
{
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"diffusivity\" NumberOfComponents=\"1\"/>\n");
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"heat_source\" NumberOfComponents=\"1\"/>\n");
}


/* ===================================== */
/* VTK binary (appended header) viewer for MPntPEnergy */
/* ===================================== */
void MPntPEnergyVTKWriteBinaryAppendedHeaderAllFields(FILE *vtk_fp,int *offset,const int N,const MPntPEnergy points[])
{
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"diffusivity\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"heat_source\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

}


/* ================================================== */
/* VTK binary (appended data) viewer for MPntPEnergy */
/* ==================================================== */
void MPntPEnergyVTKWriteBinaryAppendedDataAllFields(FILE *vtk_fp,const int N,const MPntPEnergy points[])
{
  int p,length;
  size_t atomic_size;

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].diffusivity,atomic_size,1,vtk_fp);
  }

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].heat_source,atomic_size,1,vtk_fp);
  }

}

