/*@ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 **
 **    Copyright (c) 2012
 **        Dave A. May [dave.may@erdw.ethz.ch]
 **        Institute of Geophysics
 **        ETH Zürich
 **        Sonneggstrasse 5
 **        CH-8092 Zürich
 **        Switzerland
 **
 **    project:    pTatin3d
 **    filename:   MPntPStokes_def.c
 **
 **
 **    pTatin3d is free software: you can redistribute it and/or modify
 **    it under the terms of the GNU General Public License as published
 **    by the Free Software Foundation, either version 3 of the License,
 **    or (at your option) any later version.
 **
 **    pTatin3d is distributed in the hope that it will be useful,
 **    but WITHOUT ANY WARRANTY; without even the implied warranty of
 **    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **    See the GNU General Public License for more details.
 **
 **    You should have received a copy of the GNU General Public License
 **    along with pTatin3d. If not, see <http://www.gnu.org/licenses/>.
 **
 ** ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ @*/



/*
  Auto generated by version 0.0 of swarm_class_generator.py
  on otsu.local, at 2012-02-13 00:08:18.106725 by dmay
*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "MPntPStokes_def.h"


const char MPntPStokes_classname[] = "MPntPStokes";

const int MPntPStokes_nmembers = 2;

const size_t MPntPStokes_member_sizes[] = {
  1 * sizeof(double),
  1 * sizeof(double)
} ;

const char *MPntPStokes_member_names[] = {
  "eta_effective",
  "density"
} ;


/* ===================================== */
/* Getters for MPntPStokes */
/* ===================================== */
void MPntPStokesGetField_eta_effective(MPntPStokes *point,double *data)
{
  *data = point->eta;
}

void MPntPStokesGetField_density(MPntPStokes *point,double *data)
{
  *data = point->rho;
}


/* ===================================== */
/* Setters for MPntPStokes */
/* ===================================== */
void MPntPStokesSetField_eta_effective(MPntPStokes *point,double data)
{
  point->eta = data;
}

void MPntPStokesSetField_density(MPntPStokes *point,double data)
{
  point->rho = data;
}


/* ===================================== */
/* C-viewer for MPntPStokes */
/* ===================================== */
void MPntPStokesView(MPntPStokes *point)
{
  {
    double data;
    MPntPStokesGetField_eta_effective(point,&data);
    printf("field: eta_effective = %1.6e; [size %zu; type double; variable_name eta]\n",data, MPntPStokes_member_sizes[0] );
  }
  {
    double data;
    MPntPStokesGetField_density(point,&data);
    printf("field: density = %1.6e; [size %zu; type double; variable_name rho]\n",data, MPntPStokes_member_sizes[1] );
  }
}


/* ===================================== */
/* VTK viewer for MPntPStokes */
/* ===================================== */
void MPntPStokesVTKWriteAsciiAllFields(FILE *vtk_fp,const int N,const MPntPStokes points[])
{
  int p;
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"eta\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].eta);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"rho\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].rho);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
}


/* ===================================== */
/* PVTU viewer for MPntPStokes */
/* ===================================== */
void MPntPStokesPVTUWriteAllPPointDataFields(FILE *vtk_fp)
{
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"eta\" NumberOfComponents=\"1\"/>\n");
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"rho\" NumberOfComponents=\"1\"/>\n");
}


/* ===================================== */
/* VTK binary (appended header) viewer for MPntPStokes */
/* ===================================== */
void MPntPStokesVTKWriteBinaryAppendedHeaderAllFields(FILE *vtk_fp,int *offset,const int N,const MPntPStokes points[])
{
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"eta\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"rho\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

}


/* ================================================== */
/* VTK binary (appended data) viewer for MPntPStokes */
/* ==================================================== */
void MPntPStokesVTKWriteBinaryAppendedDataAllFields(FILE *vtk_fp,const int N,const MPntPStokes points[])
{
  int p,length;
  size_t atomic_size;

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].eta,atomic_size,1,vtk_fp);
  }

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].rho,atomic_size,1,vtk_fp);
  }

}

