/*
  Auto generated by version 0.0 of material_constant_generator.py
  on geop-318.ethz.ch, at 2015-09-22 10:35:07.575907 by dmay
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <petsc.h>

#include "material_constants/EnergyConductivityThreshold_def.h"

PetscErrorCode MaterialConstantsReportParseError(const char model_name[],const char field_name[],const int region);

const char EnergyConductivityThreshold_classname[] = "EnergyConductivityThreshold";

const int EnergyConductivityThreshold_nmembers = 4;

const size_t EnergyConductivityThreshold_member_sizes[] = {
  1 * sizeof(double),
  1 * sizeof(double),
  1 * sizeof(double),
  1 * sizeof(double)
};

const char *EnergyConductivityThreshold_member_names[] = {
  "k0",
  "k1",
  "ThresholdTemperature",
  "DeltaT"
};


/* ================================================================= */
/*   Getters for EnergyConductivityThreshold */
/* ================================================================= */
void EnergyConductivityThresholdGetField_k0(EnergyConductivityThreshold *point,double *data)
{
  *data = point->k0;
}

void EnergyConductivityThresholdGetField_k1(EnergyConductivityThreshold *point,double *data)
{
  *data = point->k1;
}

void EnergyConductivityThresholdGetField_ThresholdTemperature(EnergyConductivityThreshold *point,double *data)
{
  *data = point->T_threshold;
}

void EnergyConductivityThresholdGetField_DeltaT(EnergyConductivityThreshold *point,double *data)
{
  *data = point->dT;
}


/* ================================================================= */
/*   Setters for EnergyConductivityThreshold */
/* ================================================================= */
void EnergyConductivityThresholdSetField_k0(EnergyConductivityThreshold *point,double data)
{
  point->k0 = data;
}

void EnergyConductivityThresholdSetField_k1(EnergyConductivityThreshold *point,double data)
{
  point->k1 = data;
}

void EnergyConductivityThresholdSetField_ThresholdTemperature(EnergyConductivityThreshold *point,double data)
{
  point->T_threshold = data;
}

void EnergyConductivityThresholdSetField_DeltaT(EnergyConductivityThreshold *point,double data)
{
  point->dT = data;
}


/* ================================================================= */
/*   C-viewer for EnergyConductivityThreshold */
/* ================================================================= */
void EnergyConductivityThresholdView(EnergyConductivityThreshold *point)
{
  {
    double data;
    EnergyConductivityThresholdGetField_k0(point,&data);
    printf("field: k0 = %1.6e; [size %zu; type double; variable_name k0]\n",data, EnergyConductivityThreshold_member_sizes[0] );
  }
  {
    double data;
    EnergyConductivityThresholdGetField_k1(point,&data);
    printf("field: k1 = %1.6e; [size %zu; type double; variable_name k1]\n",data, EnergyConductivityThreshold_member_sizes[1] );
  }
  {
    double data;
    EnergyConductivityThresholdGetField_ThresholdTemperature(point,&data);
    printf("field: ThresholdTemperature = %1.6e; [size %zu; type double; variable_name T_threshold]\n",data, EnergyConductivityThreshold_member_sizes[2] );
  }
  {
    double data;
    EnergyConductivityThresholdGetField_DeltaT(point,&data);
    printf("field: DeltaT = %1.6e; [size %zu; type double; variable_name dT]\n",data, EnergyConductivityThreshold_member_sizes[3] );
  }
}


/* ================================================================= */
/*   Getters for default parameters (EnergyConductivityThreshold) */
/* ================================================================= */
void EnergyConductivityThresholdGetDefault_k0(double *data)
{
  *data = (double)0.0;
}

void EnergyConductivityThresholdGetDefault_k1(double *data)
{
  *data = (double)0.0;
}

void EnergyConductivityThresholdGetDefault_ThresholdTemperature(double *data)
{
  *data = (double)0.0;
}

void EnergyConductivityThresholdGetDefault_DeltaT(double *data)
{
  *data = (double)0.0;
}

void MaterialConstantsSetDefaultAll_ConductivityThreshold(
    int nr,EnergyConductivityThreshold _data[])
{
  int r;

  for (r=0; r<nr; r++) {
    { double value;
      EnergyConductivityThresholdGetDefault_k0((double*)&value);
      EnergyConductivityThresholdSetField_k0(&_data[r],(double)value);
    }

    { double value;
      EnergyConductivityThresholdGetDefault_k1((double*)&value);
      EnergyConductivityThresholdSetField_k1(&_data[r],(double)value);
    }

    { double value;
      EnergyConductivityThresholdGetDefault_ThresholdTemperature((double*)&value);
      EnergyConductivityThresholdSetField_ThresholdTemperature(&_data[r],(double)value);
    }

    { double value;
      EnergyConductivityThresholdGetDefault_DeltaT((double*)&value);
      EnergyConductivityThresholdSetField_DeltaT(&_data[r],(double)value);
    }

  }

}

PetscErrorCode MaterialConstantsSetFromOptions_ConductivityThreshold(const char model_name[],const int region_id,EnergyConductivityThreshold _data[],PetscBool essential)
{
  char                         opt_name[PETSC_MAX_PATH_LEN];
  PetscBool                    found;
  PetscErrorCode               ierr;

  EnergyConductivityThreshold *data = &_data[region_id];
  /* options for k0 ==>> k0 */
  sprintf(opt_name,"-k0_%d",region_id);
  { PetscReal value;
    ierr = PetscOptionsGetReal(NULL,model_name,opt_name,&value,&found);CHKERRQ(ierr);
    if (found) {
      data->k0 = (double)value;
    }
    else if ( (!found)  && (essential) ) {
      ierr = MaterialConstantsReportParseError(model_name,"k0",region_id);CHKERRQ(ierr);
  }}

  /* options for k1 ==>> k1 */
  sprintf(opt_name,"-k1_%d",region_id);
  { PetscReal value;
    ierr = PetscOptionsGetReal(NULL,model_name,opt_name,&value,&found);CHKERRQ(ierr);
    if (found) {
      data->k1 = (double)value;
    }
    else if ( (!found)  && (essential) ) {
      ierr = MaterialConstantsReportParseError(model_name,"k1",region_id);CHKERRQ(ierr);
  }}

  /* options for ThresholdTemperature ==>> T_threshold */
  sprintf(opt_name,"-ThresholdTemperature_%d",region_id);
  { PetscReal value;
    ierr = PetscOptionsGetReal(NULL,model_name,opt_name,&value,&found);CHKERRQ(ierr);
    if (found) {
      data->T_threshold = (double)value;
    }
    else if ( (!found)  && (essential) ) {
      ierr = MaterialConstantsReportParseError(model_name,"ThresholdTemperature",region_id);CHKERRQ(ierr);
  }}

  /* options for DeltaT ==>> dT */
  sprintf(opt_name,"-DeltaT_%d",region_id);
  { PetscReal value;
    ierr = PetscOptionsGetReal(NULL,model_name,opt_name,&value,&found);CHKERRQ(ierr);
    if (found) {
      data->dT = (double)value;
    }
    else if ( (!found)  && (essential) ) {
      ierr = MaterialConstantsReportParseError(model_name,"DeltaT",region_id);CHKERRQ(ierr);
  }}

  PetscFunctionReturn(0);
}

PetscErrorCode MaterialConstantsPrintValues_ConductivityThreshold(const char model_name[],const int region_id,EnergyConductivityThreshold _data[])
{
  EnergyConductivityThreshold *data = &_data[region_id];
  char   opt_name[PETSC_MAX_PATH_LEN];

  PetscPrintf(PETSC_COMM_WORLD,"------------------------------------------------------------------------------------------------\n");
  PetscPrintf(PETSC_COMM_WORLD,"  MaterialView(ConductivityThreshold): RegionIndex[%d]\n", region_id);
  /* options for k0 ==>> k0 */
  sprintf(opt_name,"-%s_k0_%d", model_name,region_id);
  { double value;
    EnergyConductivityThresholdGetField_k0(data,(double*)&value);
    PetscPrintf(PETSC_COMM_WORLD,"    k0 = %1.4e (%s) \n", value,opt_name);
  }

  /* options for k1 ==>> k1 */
  sprintf(opt_name,"-%s_k1_%d", model_name,region_id);
  { double value;
    EnergyConductivityThresholdGetField_k1(data,(double*)&value);
    PetscPrintf(PETSC_COMM_WORLD,"    k1 = %1.4e (%s) \n", value,opt_name);
  }

  /* options for ThresholdTemperature ==>> T_threshold */
  sprintf(opt_name,"-%s_ThresholdTemperature_%d", model_name,region_id);
  { double value;
    EnergyConductivityThresholdGetField_ThresholdTemperature(data,(double*)&value);
    PetscPrintf(PETSC_COMM_WORLD,"    ThresholdTemperature = %1.4e (%s) \n", value,opt_name);
  }

  /* options for DeltaT ==>> dT */
  sprintf(opt_name,"-%s_DeltaT_%d", model_name,region_id);
  { double value;
    EnergyConductivityThresholdGetField_DeltaT(data,(double*)&value);
    PetscPrintf(PETSC_COMM_WORLD,"    DeltaT = %1.4e (%s) \n", value,opt_name);
  }

  PetscFunctionReturn(0);
}

PetscErrorCode MaterialConstantsSetValues_ConductivityThreshold(const int region_id,EnergyConductivityThreshold _data[],
    double k0,
    double k1,
    double T_threshold,
    double dT)
{
  EnergyConductivityThreshold *data = &_data[region_id];
  data->k0 =  k0;
  data->k1 =  k1;
  data->T_threshold =  T_threshold;
  data->dT =  dT;
  PetscFunctionReturn(0);
}

PetscErrorCode MaterialConstantsScaleValues_ConductivityThreshold(const int region_id,EnergyConductivityThreshold _data[],
    double k0,
    double k1,
    double T_threshold,
    double dT)
{
  EnergyConductivityThreshold *data = &_data[region_id];

  { double value;
    EnergyConductivityThresholdGetField_k0(data,(double*)&value);
    value = value / k0;
    EnergyConductivityThresholdSetField_k0(data,(double)value);
  }

  { double value;
    EnergyConductivityThresholdGetField_k1(data,(double*)&value);
    value = value / k1;
    EnergyConductivityThresholdSetField_k1(data,(double)value);
  }

  { double value;
    EnergyConductivityThresholdGetField_ThresholdTemperature(data,(double*)&value);
    value = value / T_threshold;
    EnergyConductivityThresholdSetField_ThresholdTemperature(data,(double)value);
  }

  { double value;
    EnergyConductivityThresholdGetField_DeltaT(data,(double*)&value);
    value = value / dT;
    EnergyConductivityThresholdSetField_DeltaT(data,(double)value);
  }

  PetscFunctionReturn(0);
}

