/*
  Auto generated by version 0.0 of material_constant_generator.py
  on geop-318.ethz.ch, at 2015-09-23 11:03:55.697669 by dmay
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <petsc.h>

#include "material_constants/EnergyMaterialConstants_def.h"

PetscErrorCode MaterialConstantsReportParseError(const char model_name[],const char field_name[],const int region);

const char EnergyMaterialConstants_classname[] = "EnergyMaterialConstants";

const int EnergyMaterialConstants_nmembers = 7;

const size_t EnergyMaterialConstants_member_sizes[] = {
  1 * sizeof(double),
  1 * sizeof(double),
  1 * sizeof(double),
  1 * sizeof(double),
  1 * sizeof(int),
  1 * sizeof(int),
  7 * sizeof(int)
};

const char *EnergyMaterialConstants_member_names[] = {
  "ThermalExpansivity",
  "Compressibility",
  "ReferenceDensity",
  "SpecificHeat",
  "DensityMethod",
  "ConductivityMethod",
  "SourceMethod"
};


/* ================================================================= */
/*   Getters for EnergyMaterialConstants */
/* ================================================================= */
void EnergyMaterialConstantsGetField_ThermalExpansivity(EnergyMaterialConstants *point,double *data)
{
  *data = point->alpha;
}

void EnergyMaterialConstantsGetField_Compressibility(EnergyMaterialConstants *point,double *data)
{
  *data = point->beta;
}

void EnergyMaterialConstantsGetField_ReferenceDensity(EnergyMaterialConstants *point,double *data)
{
  *data = point->rho_ref;
}

void EnergyMaterialConstantsGetField_SpecificHeat(EnergyMaterialConstants *point,double *data)
{
  *data = point->Cp;
}

void EnergyMaterialConstantsGetField_DensityMethod(EnergyMaterialConstants *point,int *data)
{
  *data = point->density_type;
}

void EnergyMaterialConstantsGetField_ConductivityMethod(EnergyMaterialConstants *point,int *data)
{
  *data = point->conductivity_type;
}

void EnergyMaterialConstantsGetField_SourceMethod(EnergyMaterialConstants *point,int *data[])
{
  *data = point->source_type;
}


/* ================================================================= */
/*   Setters for EnergyMaterialConstants */
/* ================================================================= */
void EnergyMaterialConstantsSetField_ThermalExpansivity(EnergyMaterialConstants *point,double data)
{
  point->alpha = data;
}

void EnergyMaterialConstantsSetField_Compressibility(EnergyMaterialConstants *point,double data)
{
  point->beta = data;
}

void EnergyMaterialConstantsSetField_ReferenceDensity(EnergyMaterialConstants *point,double data)
{
  point->rho_ref = data;
}

void EnergyMaterialConstantsSetField_SpecificHeat(EnergyMaterialConstants *point,double data)
{
  point->Cp = data;
}

void EnergyMaterialConstantsSetField_DensityMethod(EnergyMaterialConstants *point,int data)
{
  point->density_type = data;
}

void EnergyMaterialConstantsSetField_ConductivityMethod(EnergyMaterialConstants *point,int data)
{
  point->conductivity_type = data;
}

void EnergyMaterialConstantsSetField_SourceMethod(EnergyMaterialConstants *point,int data[])
{
  memcpy( &point->source_type[0], data, sizeof(int)*7 );
}

void EnergyMaterialConstantsSetFieldByIndex_SourceMethod(EnergyMaterialConstants *point,int index,int value)
{
  point->source_type[index] = value;
}

void EnergyMaterialConstantsSetFieldAll_SourceMethod(EnergyMaterialConstants *point,int value)
{
  point->source_type[0] = value;
  point->source_type[1] = value;
  point->source_type[2] = value;
  point->source_type[3] = value;
  point->source_type[4] = value;
  point->source_type[5] = value;
  point->source_type[6] = value;
}


/* ================================================================= */
/*   C-viewer for EnergyMaterialConstants */
/* ================================================================= */
void EnergyMaterialConstantsView(EnergyMaterialConstants *point)
{
  {
    double data;
    EnergyMaterialConstantsGetField_ThermalExpansivity(point,&data);
    printf("field: ThermalExpansivity = %1.6e; [size %zu; type double; variable_name alpha]\n",data, EnergyMaterialConstants_member_sizes[0] );
  }
  {
    double data;
    EnergyMaterialConstantsGetField_Compressibility(point,&data);
    printf("field: Compressibility = %1.6e; [size %zu; type double; variable_name beta]\n",data, EnergyMaterialConstants_member_sizes[1] );
  }
  {
    double data;
    EnergyMaterialConstantsGetField_ReferenceDensity(point,&data);
    printf("field: ReferenceDensity = %1.6e; [size %zu; type double; variable_name rho_ref]\n",data, EnergyMaterialConstants_member_sizes[2] );
  }
  {
    double data;
    EnergyMaterialConstantsGetField_SpecificHeat(point,&data);
    printf("field: SpecificHeat = %1.6e; [size %zu; type double; variable_name Cp]\n",data, EnergyMaterialConstants_member_sizes[3] );
  }
  {
    int data;
    EnergyMaterialConstantsGetField_DensityMethod(point,&data);
    printf("field: DensityMethod = %d; [size %zu; type int; variable_name density_type]\n",data, EnergyMaterialConstants_member_sizes[4] );
  }
  {
    int data;
    EnergyMaterialConstantsGetField_ConductivityMethod(point,&data);
    printf("field: ConductivityMethod = %d; [size %zu; type int; variable_name conductivity_type]\n",data, EnergyMaterialConstants_member_sizes[5] );
  }
  {
    int *data;
    EnergyMaterialConstantsGetField_SourceMethod(point,&data);
    printf("field: SourceMethod[0] = %d; [size %zu; type int; variable_name source_type]\n",data[0], EnergyMaterialConstants_member_sizes[6] );
    printf("field: SourceMethod[1] = %d; [size %zu; type int; variable_name source_type]\n",data[1], EnergyMaterialConstants_member_sizes[6] );
    printf("field: SourceMethod[2] = %d; [size %zu; type int; variable_name source_type]\n",data[2], EnergyMaterialConstants_member_sizes[6] );
    printf("field: SourceMethod[3] = %d; [size %zu; type int; variable_name source_type]\n",data[3], EnergyMaterialConstants_member_sizes[6] );
    printf("field: SourceMethod[4] = %d; [size %zu; type int; variable_name source_type]\n",data[4], EnergyMaterialConstants_member_sizes[6] );
    printf("field: SourceMethod[5] = %d; [size %zu; type int; variable_name source_type]\n",data[5], EnergyMaterialConstants_member_sizes[6] );
    printf("field: SourceMethod[6] = %d; [size %zu; type int; variable_name source_type]\n",data[6], EnergyMaterialConstants_member_sizes[6] );
  }
}


/* ================================================================= */
/*   Getters for default parameters (EnergyMaterialConstants) */
/* ================================================================= */
void EnergyMaterialConstantsGetDefault_ThermalExpansivity(double *data)
{
  *data = (double)0.0;
}

void EnergyMaterialConstantsGetDefault_Compressibility(double *data)
{
  *data = (double)0.0;
}

void EnergyMaterialConstantsGetDefault_ReferenceDensity(double *data)
{
  *data = (double)0.0;
}

void EnergyMaterialConstantsGetDefault_SpecificHeat(double *data)
{
  *data = (double)1.0;
}

void EnergyMaterialConstantsGetDefault_DensityMethod(int *data)
{
  *data = (int)0;
}

void EnergyMaterialConstantsGetDefault_ConductivityMethod(int *data)
{
  *data = (int)0;
}

void EnergyMaterialConstantsGetDefault_SourceMethod(int *data)
{
  *data = (int)0;
}

void MaterialConstantsSetDefaultAll_EnergyMaterialConstants(
    int nr,EnergyMaterialConstants _data[])
{
  int r;

  for (r=0; r<nr; r++) {
    { double value;
      EnergyMaterialConstantsGetDefault_ThermalExpansivity((double*)&value);
      EnergyMaterialConstantsSetField_ThermalExpansivity(&_data[r],(double)value);
    }

    { double value;
      EnergyMaterialConstantsGetDefault_Compressibility((double*)&value);
      EnergyMaterialConstantsSetField_Compressibility(&_data[r],(double)value);
    }

    { double value;
      EnergyMaterialConstantsGetDefault_ReferenceDensity((double*)&value);
      EnergyMaterialConstantsSetField_ReferenceDensity(&_data[r],(double)value);
    }

    { double value;
      EnergyMaterialConstantsGetDefault_SpecificHeat((double*)&value);
      EnergyMaterialConstantsSetField_SpecificHeat(&_data[r],(double)value);
    }

    { int value;
      EnergyMaterialConstantsGetDefault_DensityMethod((int*)&value);
      EnergyMaterialConstantsSetField_DensityMethod(&_data[r],(int)value);
    }

    { int value;
      EnergyMaterialConstantsGetDefault_ConductivityMethod((int*)&value);
      EnergyMaterialConstantsSetField_ConductivityMethod(&_data[r],(int)value);
    }

    { int value;
      EnergyMaterialConstantsGetDefault_SourceMethod((int*)&value);
      _data[r].source_type[0] = value;
      _data[r].source_type[1] = value;
      _data[r].source_type[2] = value;
      _data[r].source_type[3] = value;
      _data[r].source_type[4] = value;
      _data[r].source_type[5] = value;
      _data[r].source_type[6] = value;
    }

  }

}

PetscErrorCode MaterialConstantsSetFromOptions_EnergyMaterialConstants(const char model_name[],const int region_id,EnergyMaterialConstants _data[],PetscBool essential)
{
  char                         opt_name[PETSC_MAX_PATH_LEN];
  PetscBool                    found;
  PetscErrorCode               ierr;

  EnergyMaterialConstants *data = &_data[region_id];
  /* options for ThermalExpansivity ==>> alpha */
  sprintf(opt_name,"-ThermalExpansivity_%d",region_id);
  { PetscReal value;
    ierr = PetscOptionsGetReal(NULL,model_name,opt_name,&value,&found);CHKERRQ(ierr);
    if (found) {
      data->alpha = (double)value;
    }
    else if ( (!found)  && (essential) ) {
      ierr = MaterialConstantsReportParseError(model_name,"ThermalExpansivity",region_id);CHKERRQ(ierr);
  }}

  /* options for Compressibility ==>> beta */
  sprintf(opt_name,"-Compressibility_%d",region_id);
  { PetscReal value;
    ierr = PetscOptionsGetReal(NULL,model_name,opt_name,&value,&found);CHKERRQ(ierr);
    if (found) {
      data->beta = (double)value;
    }
    else if ( (!found)  && (essential) ) {
      ierr = MaterialConstantsReportParseError(model_name,"Compressibility",region_id);CHKERRQ(ierr);
  }}

  /* options for ReferenceDensity ==>> rho_ref */
  sprintf(opt_name,"-ReferenceDensity_%d",region_id);
  { PetscReal value;
    ierr = PetscOptionsGetReal(NULL,model_name,opt_name,&value,&found);CHKERRQ(ierr);
    if (found) {
      data->rho_ref = (double)value;
    }
    else if ( (!found)  && (essential) ) {
      ierr = MaterialConstantsReportParseError(model_name,"ReferenceDensity",region_id);CHKERRQ(ierr);
  }}

  /* options for SpecificHeat ==>> Cp */
  sprintf(opt_name,"-SpecificHeat_%d",region_id);
  { PetscReal value;
    ierr = PetscOptionsGetReal(NULL,model_name,opt_name,&value,&found);CHKERRQ(ierr);
    if (found) {
      data->Cp = (double)value;
    }
    else if ( (!found)  && (essential) ) {
      ierr = MaterialConstantsReportParseError(model_name,"SpecificHeat",region_id);CHKERRQ(ierr);
  }}

  /* options for DensityMethod ==>> density_type */
  sprintf(opt_name,"-DensityMethod_%d",region_id);
  { PetscInt value;
    ierr = PetscOptionsGetInt(NULL,model_name,opt_name,&value,&found);CHKERRQ(ierr);
    if (found) {
      data->density_type = (int)value;
    }
    else if ( (!found)  && (essential) ) {
      ierr = MaterialConstantsReportParseError(model_name,"DensityMethod",region_id);CHKERRQ(ierr);
  }}

  /* options for ConductivityMethod ==>> conductivity_type */
  sprintf(opt_name,"-ConductivityMethod_%d",region_id);
  { PetscInt value;
    ierr = PetscOptionsGetInt(NULL,model_name,opt_name,&value,&found);CHKERRQ(ierr);
    if (found) {
      data->conductivity_type = (int)value;
    }
    else if ( (!found)  && (essential) ) {
      ierr = MaterialConstantsReportParseError(model_name,"ConductivityMethod",region_id);CHKERRQ(ierr);
  }}

  /* options for SourceMethod ==>> source_type */
  sprintf(opt_name,"-SourceMethod_%d",region_id);
  { PetscInt value[7];
    PetscInt nv;
    ierr = PetscOptionsGetIntArray(NULL,model_name,opt_name,value,&nv,&found);CHKERRQ(ierr);
    if (found) {
      data->source_type[0] = (int)value[0];
      data->source_type[1] = (int)value[1];
      data->source_type[2] = (int)value[2];
      data->source_type[3] = (int)value[3];
      data->source_type[4] = (int)value[4];
      data->source_type[5] = (int)value[5];
      data->source_type[6] = (int)value[6];
    }
    else if ( (!found)  && (essential) ) {
      ierr = MaterialConstantsReportParseError(model_name,"SourceMethod",region_id);CHKERRQ(ierr);
  }}

  PetscFunctionReturn(0);
}

PetscErrorCode MaterialConstantsPrintValues_EnergyMaterialConstants(const char model_name[],const int region_id,EnergyMaterialConstants _data[])
{
  EnergyMaterialConstants *data = &_data[region_id];
  char   opt_name[PETSC_MAX_PATH_LEN];

  PetscPrintf(PETSC_COMM_WORLD,"------------------------------------------------------------------------------------------------\n");
  PetscPrintf(PETSC_COMM_WORLD,"  MaterialView(EnergyMaterialConstants): RegionIndex[%d]\n", region_id);
  /* options for ThermalExpansivity ==>> alpha */
  sprintf(opt_name,"-%s_ThermalExpansivity_%d", model_name,region_id);
  { double value;
    EnergyMaterialConstantsGetField_ThermalExpansivity(data,(double*)&value);
    PetscPrintf(PETSC_COMM_WORLD,"    ThermalExpansivity = %1.4e (%s) \n", value,opt_name);
  }

  /* options for Compressibility ==>> beta */
  sprintf(opt_name,"-%s_Compressibility_%d", model_name,region_id);
  { double value;
    EnergyMaterialConstantsGetField_Compressibility(data,(double*)&value);
    PetscPrintf(PETSC_COMM_WORLD,"    Compressibility = %1.4e (%s) \n", value,opt_name);
  }

  /* options for ReferenceDensity ==>> rho_ref */
  sprintf(opt_name,"-%s_ReferenceDensity_%d", model_name,region_id);
  { double value;
    EnergyMaterialConstantsGetField_ReferenceDensity(data,(double*)&value);
    PetscPrintf(PETSC_COMM_WORLD,"    ReferenceDensity = %1.4e (%s) \n", value,opt_name);
  }

  /* options for SpecificHeat ==>> Cp */
  sprintf(opt_name,"-%s_SpecificHeat_%d", model_name,region_id);
  { double value;
    EnergyMaterialConstantsGetField_SpecificHeat(data,(double*)&value);
    PetscPrintf(PETSC_COMM_WORLD,"    SpecificHeat = %1.4e (%s) \n", value,opt_name);
  }

  /* options for DensityMethod ==>> density_type */
  sprintf(opt_name,"-%s_DensityMethod_%d", model_name,region_id);
  { int value;
    EnergyMaterialConstantsGetField_DensityMethod(data,(int*)&value);
    PetscPrintf(PETSC_COMM_WORLD,"    DensityMethod = %d (%s) \n", value,opt_name);
  }

  /* options for ConductivityMethod ==>> conductivity_type */
  sprintf(opt_name,"-%s_ConductivityMethod_%d", model_name,region_id);
  { int value;
    EnergyMaterialConstantsGetField_ConductivityMethod(data,(int*)&value);
    PetscPrintf(PETSC_COMM_WORLD,"    ConductivityMethod = %d (%s) \n", value,opt_name);
  }

  /* options for SourceMethod ==>> source_type */
  sprintf(opt_name,"-%s_SourceMethod_%d", model_name,region_id);
  PetscFunctionReturn(0);
}

PetscErrorCode MaterialConstantsSetValues_EnergyMaterialConstants(const int region_id,EnergyMaterialConstants _data[],
    double alpha,
    double beta,
    double rho_ref,
    double Cp,
    int density_type,
    int conductivity_type,
    int *source_type)
{
  EnergyMaterialConstants *data = &_data[region_id];
  data->alpha =  alpha;
  data->beta =  beta;
  data->rho_ref =  rho_ref;
  data->Cp =  Cp;
  data->density_type =  density_type;
  data->conductivity_type =  conductivity_type;
  if (source_type) {
    memcpy(&data->source_type,source_type,7*sizeof(int));
  }
  PetscFunctionReturn(0);
}

PetscErrorCode MaterialConstantsScaleValues_EnergyMaterialConstants(const int region_id,EnergyMaterialConstants _data[],
    double alpha,
    double beta,
    double rho_ref,
    double Cp)
{
  EnergyMaterialConstants *data = &_data[region_id];

  { double value;
    EnergyMaterialConstantsGetField_ThermalExpansivity(data,(double*)&value);
    value = value / alpha;
    EnergyMaterialConstantsSetField_ThermalExpansivity(data,(double)value);
  }

  { double value;
    EnergyMaterialConstantsGetField_Compressibility(data,(double*)&value);
    value = value / beta;
    EnergyMaterialConstantsSetField_Compressibility(data,(double)value);
  }

  { double value;
    EnergyMaterialConstantsGetField_ReferenceDensity(data,(double*)&value);
    value = value / rho_ref;
    EnergyMaterialConstantsSetField_ReferenceDensity(data,(double)value);
  }

  { double value;
    EnergyMaterialConstantsGetField_SpecificHeat(data,(double*)&value);
    value = value / Cp;
    EnergyMaterialConstantsSetField_SpecificHeat(data,(double)value);
  }

  PetscFunctionReturn(0);
}

