/*@ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 **
 **    Copyright (c) 2012
 **        Dave A. May [dave.may@erdw.ethz.ch]
 **        Institute of Geophysics
 **        ETH Zürich
 **        Sonneggstrasse 5
 **        CH-8092 Zürich
 **        Switzerland
 **
 **    project:    pTatin3d
 **    filename:   MaterialConst_PlasticMises_def.c
 **
 **
 **    pTatin3d is free software: you can redistribute it and/or modify
 **    it under the terms of the GNU General Public License as published
 **    by the Free Software Foundation, either version 3 of the License,
 **    or (at your option) any later version.
 **
 **    pTatin3d is distributed in the hope that it will be useful,
 **    but WITHOUT ANY WARRANTY; without even the implied warranty of
 **    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **    See the GNU General Public License for more details.
 **
 **    You should have received a copy of the GNU General Public License
 **    along with pTatin3d. If not, see <http://www.gnu.org/licenses/>.
 **
 ** ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ @*/
/*
  Auto generated by version 0.0 of swarm_class_generator.py
  on les-MacBook-Pro.local, at 2013-03-08 17:43:59.346002 by laetitia
*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "material_constants/MaterialConst_PlasticMises_def.h"


const char MaterialConst_PlasticMises_classname[] = "MaterialConst_PlasticMises";

const int MaterialConst_PlasticMises_nmembers = 2;

const size_t MaterialConst_PlasticMises_member_sizes[] = {
  1 * sizeof(double),
  1 * sizeof(double)
} ;

const char *MaterialConst_PlasticMises_member_names[] = {
  "yield_stress",
  "yield_stress_inf"
} ;


/* ===================================== */
/* Getters for MaterialConst_PlasticMises */
/* ===================================== */
void MaterialConst_PlasticMisesGetField_yield_stress(MaterialConst_PlasticMises *point,double *data)
{
  *data = point->tau_yield;
}

void MaterialConst_PlasticMisesGetField_yield_stress_inf(MaterialConst_PlasticMises *point,double *data)
{
  *data = point->tau_yield_inf;
}


/* ===================================== */
/* Setters for MaterialConst_PlasticMises */
/* ===================================== */
void MaterialConst_PlasticMisesSetField_yield_stress(MaterialConst_PlasticMises *point,double data)
{
  point->tau_yield = data;
}

void MaterialConst_PlasticMisesSetField_yield_stress_inf(MaterialConst_PlasticMises *point,double data)
{
  point->tau_yield_inf = data;
}


/* ===================================== */
/* C-viewer for MaterialConst_PlasticMises */
/* ===================================== */
void MaterialConst_PlasticMisesView(MaterialConst_PlasticMises *point)
{
  {
    double data;
    MaterialConst_PlasticMisesGetField_yield_stress(point,&data);
    printf("field: yield_stress = %1.6e; [size %zu; type double; variable_name tau_yield]\n",data, MaterialConst_PlasticMises_member_sizes[0] );
  }
  {
    double data;
    MaterialConst_PlasticMisesGetField_yield_stress_inf(point,&data);
    printf("field: yield_stress_inf = %1.6e; [size %zu; type double; variable_name tau_yield_inf]\n",data, MaterialConst_PlasticMises_member_sizes[1] );
  }
}


/* ===================================== */
/* VTK viewer for MaterialConst_PlasticMises */
/* ===================================== */
void MaterialConst_PlasticMisesVTKWriteAsciiAllFields(FILE *vtk_fp,const int N,const MaterialConst_PlasticMises points[])
{
  int p;
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"tau_yield\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].tau_yield);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"tau_yield_inf\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].tau_yield_inf);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
}


/* ===================================== */
/* PVTU viewer for MaterialConst_PlasticMises */
/* ===================================== */
void MaterialConst_PlasticMisesPVTUWriteAllPPointDataFields(FILE *vtk_fp)
{
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"tau_yield\" NumberOfComponents=\"1\"/>\n");
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"tau_yield_inf\" NumberOfComponents=\"1\"/>\n");
}


/* ===================================== */
/* VTK binary (appended header) viewer for MaterialConst_PlasticMises */
/* ===================================== */
void MaterialConst_PlasticMisesVTKWriteBinaryAppendedHeaderAllFields(FILE *vtk_fp,int *offset,const int N,const MaterialConst_PlasticMises points[])
{
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"tau_yield\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"tau_yield_inf\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

}


/* ================================================== */
/* VTK binary (appended data) viewer for MaterialConst_PlasticMises */
/* ==================================================== */
void MaterialConst_PlasticMisesVTKWriteBinaryAppendedDataAllFields(FILE *vtk_fp,const int N,const MaterialConst_PlasticMises points[])
{
  int p,length;
  size_t atomic_size;

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].tau_yield,atomic_size,1,vtk_fp);
  }

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].tau_yield_inf,atomic_size,1,vtk_fp);
  }

}

