/*@ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 **
 **    Copyright (c) 2012
 **        Dave A. May [dave.may@erdw.ethz.ch]
 **        Institute of Geophysics
 **        ETH Zürich
 **        Sonneggstrasse 5
 **        CH-8092 Zürich
 **        Switzerland
 **
 **    project:    pTatin3d
 **    filename:   MaterialConst_ViscosityArrh_def.c
 **
 **
 **    pTatin3d is free software: you can redistribute it and/or modify
 **    it under the terms of the GNU General Public License as published
 **    by the Free Software Foundation, either version 3 of the License,
 **    or (at your option) any later version.
 **
 **    pTatin3d is distributed in the hope that it will be useful,
 **    but WITHOUT ANY WARRANTY; without even the implied warranty of
 **    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **    See the GNU General Public License for more details.
 **
 **    You should have received a copy of the GNU General Public License
 **    along with pTatin3d. If not, see <http://www.gnu.org/licenses/>.
 **
 ** ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ @*/
/*
  Auto generated by version 0.0 of swarm_class_generator.py
  on les-MacBook-Pro.local, at 2013-03-10 16:15:11.875312 by laetitia
*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "material_constants/MaterialConst_ViscosityArrh_def.h"


const char MaterialConst_ViscosityArrh_classname[] = "MaterialConst_ViscosityArrh";

const int MaterialConst_ViscosityArrh_nmembers = 8;

const size_t MaterialConst_ViscosityArrh_member_sizes[] = {
  1 * sizeof(double),
  1 * sizeof(double),
  1 * sizeof(double),
  1 * sizeof(double),
  1 * sizeof(double),
  1 * sizeof(double),
  1 * sizeof(double),
  1 * sizeof(double)
} ;

const char *MaterialConst_ViscosityArrh_member_names[] = {
  "preexpA",
  "Ascale",
  "entalpy",
  "Vmol",
  "nexp",
  "Tref",
  "Eta_scale",
  "P_scale"
} ;


/* ===================================== */
/* Getters for MaterialConst_ViscosityArrh */
/* ===================================== */
void MaterialConst_ViscosityArrhGetField_preexpA(MaterialConst_ViscosityArrh *point,double *data)
{
  *data = point->preexpA;
}

void MaterialConst_ViscosityArrhGetField_Ascale(MaterialConst_ViscosityArrh *point,double *data)
{
  *data = point->Ascale;
}

void MaterialConst_ViscosityArrhGetField_entalpy(MaterialConst_ViscosityArrh *point,double *data)
{
  *data = point->entalpy;
}

void MaterialConst_ViscosityArrhGetField_Vmol(MaterialConst_ViscosityArrh *point,double *data)
{
  *data = point->Vmol;
}

void MaterialConst_ViscosityArrhGetField_nexp(MaterialConst_ViscosityArrh *point,double *data)
{
  *data = point->nexp;
}

void MaterialConst_ViscosityArrhGetField_Tref(MaterialConst_ViscosityArrh *point,double *data)
{
  *data = point->Tref;
}

void MaterialConst_ViscosityArrhGetField_Eta_scale(MaterialConst_ViscosityArrh *point,double *data)
{
  *data = point->Eta_scale;
}

void MaterialConst_ViscosityArrhGetField_P_scale(MaterialConst_ViscosityArrh *point,double *data)
{
  *data = point->P_scale;
}


/* ===================================== */
/* Setters for MaterialConst_ViscosityArrh */
/* ===================================== */
void MaterialConst_ViscosityArrhSetField_preexpA(MaterialConst_ViscosityArrh *point,double data)
{
  point->preexpA = data;
}

void MaterialConst_ViscosityArrhSetField_Ascale(MaterialConst_ViscosityArrh *point,double data)
{
  point->Ascale = data;
}

void MaterialConst_ViscosityArrhSetField_entalpy(MaterialConst_ViscosityArrh *point,double data)
{
  point->entalpy = data;
}

void MaterialConst_ViscosityArrhSetField_Vmol(MaterialConst_ViscosityArrh *point,double data)
{
  point->Vmol = data;
}

void MaterialConst_ViscosityArrhSetField_nexp(MaterialConst_ViscosityArrh *point,double data)
{
  point->nexp = data;
}

void MaterialConst_ViscosityArrhSetField_Tref(MaterialConst_ViscosityArrh *point,double data)
{
  point->Tref = data;
}

void MaterialConst_ViscosityArrhSetField_Eta_scale(MaterialConst_ViscosityArrh *point,double data)
{
  point->Eta_scale = data;
}

void MaterialConst_ViscosityArrhSetField_P_scale(MaterialConst_ViscosityArrh *point,double data)
{
  point->P_scale = data;
}


/* ===================================== */
/* C-viewer for MaterialConst_ViscosityArrh */
/* ===================================== */
void MaterialConst_ViscosityArrhView(MaterialConst_ViscosityArrh *point)
{
  {
    double data;
    MaterialConst_ViscosityArrhGetField_preexpA(point,&data);
    printf("field: preexpA = %1.6e; [size %zu; type double; variable_name preexpA]\n",data, MaterialConst_ViscosityArrh_member_sizes[0] );
  }
  {
    double data;
    MaterialConst_ViscosityArrhGetField_Ascale(point,&data);
    printf("field: Ascale = %1.6e; [size %zu; type double; variable_name Ascale]\n",data, MaterialConst_ViscosityArrh_member_sizes[1] );
  }
  {
    double data;
    MaterialConst_ViscosityArrhGetField_entalpy(point,&data);
    printf("field: entalpy = %1.6e; [size %zu; type double; variable_name entalpy]\n",data, MaterialConst_ViscosityArrh_member_sizes[2] );
  }
  {
    double data;
    MaterialConst_ViscosityArrhGetField_Vmol(point,&data);
    printf("field: Vmol = %1.6e; [size %zu; type double; variable_name Vmol]\n",data, MaterialConst_ViscosityArrh_member_sizes[3] );
  }
  {
    double data;
    MaterialConst_ViscosityArrhGetField_nexp(point,&data);
    printf("field: nexp = %1.6e; [size %zu; type double; variable_name nexp]\n",data, MaterialConst_ViscosityArrh_member_sizes[4] );
  }
  {
    double data;
    MaterialConst_ViscosityArrhGetField_Tref(point,&data);
    printf("field: Tref = %1.6e; [size %zu; type double; variable_name Tref]\n",data, MaterialConst_ViscosityArrh_member_sizes[5] );
  }
  {
    double data;
    MaterialConst_ViscosityArrhGetField_Eta_scale(point,&data);
    printf("field: Eta_scale = %1.6e; [size %zu; type double; variable_name Eta_scale]\n",data, MaterialConst_ViscosityArrh_member_sizes[6] );
  }
  {
    double data;
    MaterialConst_ViscosityArrhGetField_P_scale(point,&data);
    printf("field: P_scale = %1.6e; [size %zu; type double; variable_name P_scale]\n",data, MaterialConst_ViscosityArrh_member_sizes[7] );
  }
}


/* ===================================== */
/* VTK viewer for MaterialConst_ViscosityArrh */
/* ===================================== */
void MaterialConst_ViscosityArrhVTKWriteAsciiAllFields(FILE *vtk_fp,const int N,const MaterialConst_ViscosityArrh points[])
{
  int p;
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"preexpA\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].preexpA);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"Ascale\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].Ascale);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"entalpy\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].entalpy);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"Vmol\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].Vmol);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"nexp\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].nexp);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"Tref\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].Tref);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"Eta_scale\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].Eta_scale);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"P_scale\" format=\"ascii\">\n");
  for(p=0;p<N;p++) {
    fprintf( vtk_fp,"\t\t\t\t\t%lf\n",(double)points[p].P_scale);
  }
  fprintf( vtk_fp, "\t\t\t\t</DataArray>\n");
}


/* ===================================== */
/* PVTU viewer for MaterialConst_ViscosityArrh */
/* ===================================== */
void MaterialConst_ViscosityArrhPVTUWriteAllPPointDataFields(FILE *vtk_fp)
{
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"preexpA\" NumberOfComponents=\"1\"/>\n");
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"Ascale\" NumberOfComponents=\"1\"/>\n");
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"entalpy\" NumberOfComponents=\"1\"/>\n");
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"Vmol\" NumberOfComponents=\"1\"/>\n");
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"nexp\" NumberOfComponents=\"1\"/>\n");
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"Tref\" NumberOfComponents=\"1\"/>\n");
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"Eta_scale\" NumberOfComponents=\"1\"/>\n");
  fprintf(vtk_fp, "\t\t\t<PDataArray type=\"Float64\" Name=\"P_scale\" NumberOfComponents=\"1\"/>\n");
}


/* ===================================== */
/* VTK binary (appended header) viewer for MaterialConst_ViscosityArrh */
/* ===================================== */
void MaterialConst_ViscosityArrhVTKWriteBinaryAppendedHeaderAllFields(FILE *vtk_fp,int *offset,const int N,const MaterialConst_ViscosityArrh points[])
{
  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"preexpA\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"Ascale\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"entalpy\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"Vmol\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"nexp\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"Tref\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"Eta_scale\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

  fprintf( vtk_fp, "\t\t\t\t<DataArray type=\"Float64\" Name=\"P_scale\" format=\"appended\"  offset=\"%d\" />\n",*offset);
  *offset = *offset + sizeof(int) + N * sizeof(double);

}


/* ================================================== */
/* VTK binary (appended data) viewer for MaterialConst_ViscosityArrh */
/* ==================================================== */
void MaterialConst_ViscosityArrhVTKWriteBinaryAppendedDataAllFields(FILE *vtk_fp,const int N,const MaterialConst_ViscosityArrh points[])
{
  int p,length;
  size_t atomic_size;

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].preexpA,atomic_size,1,vtk_fp);
  }

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].Ascale,atomic_size,1,vtk_fp);
  }

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].entalpy,atomic_size,1,vtk_fp);
  }

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].Vmol,atomic_size,1,vtk_fp);
  }

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].nexp,atomic_size,1,vtk_fp);
  }

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].Tref,atomic_size,1,vtk_fp);
  }

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].Eta_scale,atomic_size,1,vtk_fp);
  }

  atomic_size = sizeof(double);
  length = (int)( atomic_size * ((size_t)N) );
  fwrite( &length,sizeof(int),1,vtk_fp);
  for(p=0;p<N;p++) {
    fwrite( &points[p].P_scale,atomic_size,1,vtk_fp);
  }

}

