
import os
import socket
import sys
import time
import datetime



def write_out_c_class_externdefs( MatPropClass, MatPropClassShortName, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list ):

	#check length
	L = len(variable_name_list);
	if L != len(variable_type_list):
		print 'ERROR: length variable_name_list[] != variable_name_list[]'
	if L != len(variable_textural_name_list):
		print 'ERROR: length variable_textural_name_list[] != variable_name_list[]'

	print '\n\n\n#error(<<REMOVED AUTOGENERATED TAG>> ================== FILE ['+MatPropClass+'_def.c] ==================)'

	# comment
	now = datetime.datetime.now()
	print '/*'
	print '  Auto generated by version 0.0 of mat_prop_class_generator.py'
	print '  on '+ socket.gethostname() +', at '+str(now)+' by '+os.getenv('USER')
	print '*/\n\n'


	print '#include <stdio.h>'
	print '#include <string.h>'
	print '#include <stdlib.h>\n'
	print '#include "'+MatPropClass+'_def.h"\n\n'

	# generate classname
	print 'const char '+MatPropClass+'_classname[] = "'+MatPropClass+'";\n'

	print 'const char '+MatPropClass+'_classname_short[] = "'+MatPropClassShortName+'";\n'

	# strings and constant stuff #
	print 'const int ' + MatPropClass +'_nmembers = ' + str(L) + ';\n'


	# sizes #
	l = 'const size_t ' + MatPropClass +'_member_sizes[] = {'
	print l
	for f in xrange(L):
		l = '  ' + str(variable_extend_list[f])  + ' * sizeof(' + str(variable_type_list[f]) +')'
		if f < L-1:
			l = l + ','
		print l
	print '} ;\n'


	# memory offset sizes #
	# compute offsets
	memoffset = [0] * L
	memoffset_count = '0'
	for f in range(0,L):
		memoffset[f] = memoffset_count;
		memoffset_count = memoffset_count + ' + ' + str(variable_extend_list[f])  + '*sizeof(' + str(variable_type_list[f]) +')'
#	print memoffset

	# write offsets
	l = 'const size_t ' + MatPropClass +'_member_byte_offset[] = {'
	print l
	for f in xrange(L):
		l = '  ' + str(memoffset[f])
		if f < L-1:
			l = l + ','
		print l
	print '} ;\n'


	# string names #
	l = 'const char *' + MatPropClass +'_member_names_short[] = {'
	print l
	for f in xrange(L):
		l = '  ' + '"' + variable_name_list[f] + '"'
		if f < L-1:
			l = l + ','
		print l

	l = '} ;\n'
	print l

	# string names #
	l = 'const char *' + MatPropClass +'_member_names[] = {'
	print l
	for f in xrange(L):
		l = '  ' + '"' + variable_textural_name_list[f] + '"'
		if f < L-1:
			l = l + ','
		print l

	l = '} ;\n'
	print l



def write_out_getters( prototype, MatPropClass, MatPropClassShortName, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list ):

	#check length
	L = len(variable_name_list);

	# comment
	if prototype == 'False':
		print '\n/* ===================================== */'
		print '/* Getters for '+MatPropClass+' */'
		print '/* ===================================== */'

	for f in xrange(L):

		if variable_extend_list[f] == 1:

			if prototype == 'True':
				print 'void '+ MatPropClass +'GetField_'+variable_textural_name_list[f]+'('+MatPropClass+' *point,'+variable_type_list[f]+' *data);'
				continue


			l = 'void '+ MatPropClass +'GetField_'+variable_textural_name_list[f]+'('+MatPropClass+' *point,'+variable_type_list[f]+' *data) \n{'
			print l

			l = '  *data = point->'+variable_name_list[f]+';'
			print l
			print '}\n'

		else:

			if prototype == 'True':
				print 'void '+ MatPropClass +'GetField_'+variable_textural_name_list[f]+'('+MatPropClass+' *point,'+variable_type_list[f]+' *data[]);'
				continue

			l = 'void '+ MatPropClass +'GetField_'+variable_textural_name_list[f]+'('+MatPropClass+' *point,'+variable_type_list[f]+' *data[]) \n{'
			print l


			l = '  *data = point->'+variable_name_list[f]+';'
			print l
			print '}\n'


def write_out_setters( protoype, MatPropClass, MatPropClassShortName, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list ):

	#check length
	L = len(variable_name_list);

	if protoype == 'False':
		print '\n/* ===================================== */'
		print '/* Setters for '+MatPropClass+' */'
		print '/* ===================================== */'

	for f in xrange(L):

		if variable_extend_list[f] == 1:
			if protoype == 'True':
				print 'void '+ MatPropClass +'SetField_'+variable_textural_name_list[f]+'('+MatPropClass+' *point,'+variable_type_list[f]+' data);'
				continue

			l = 'void '+ MatPropClass +'SetField_'+variable_textural_name_list[f]+'('+MatPropClass+' *point,'+variable_type_list[f]+' data) \n{'
			print l

			l = '  point->'+variable_name_list[f]+' = data;'
			print l
			print '}\n'

		else:
			if protoype == 'True':
				print 'void '+ MatPropClass +'SetField_'+variable_textural_name_list[f]+'('+MatPropClass+' *point,'+variable_type_list[f]+' data[]);'
				continue

			l = 'void '+ MatPropClass +'SetField_'+variable_textural_name_list[f]+'('+MatPropClass+' *point,'+variable_type_list[f]+' data[]) \n{'
			print l


			l = '  memcpy( &point->'+variable_name_list[f]+'[0], data, sizeof('+variable_type_list[f]+')*'+str(variable_extend_list[f])+' );'
			print l

			print '}\n'



def write_out_viewer( prototype, MatPropClass, MatPropClassShortName, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list ):

	#check length
	L = len(variable_name_list);

	if prototype == 'False':
		print '\n/* ===================================== */'
		print '/* C-viewer for '+MatPropClass+' */'
		print '/* ===================================== */'

	if prototype == 'True':
		print 'void '+MatPropClass+'View('+MatPropClass+' *point);'
		return

	l = 'void '+MatPropClass+'View('+MatPropClass+' *point)\n{'
	print l

	type   = [ 'float', 'double', 'char', 'int', 'long int' ]
	format = [ '%1.6e', '%1.6e' ,   '%c',  '%d', '%ld' ]


	for f in xrange(L):

		print '  {'
		if variable_extend_list[f] == 1:
			print '    '+variable_type_list[f]+' data;'
		else:
			print '    '+variable_type_list[f]+' *data;'

		print '    '+MatPropClass+'GetField_'+variable_textural_name_list[f]+'(point,&data);'


		if variable_extend_list[f] == 1:

			format_i = ''
			for i in xrange(len(type)):
				if variable_type_list[f] == type[i]:
					format_i = format[i]
					break

			print '    printf(\"field: '+variable_textural_name_list[f]+' = '+format_i+'; [size %zu; type '+variable_type_list[f]+'; variable_name '+variable_name_list[f]+']\\n\",data, '+MatPropClass+'_member_sizes['+str(f)+'] );'

		else:

			format_i = ''
			for i in xrange(len(type)):
				if variable_type_list[f] == type[i]:
					format_i = format[i]
					break

			for K in xrange(variable_extend_list[f]):
				print '    printf(\"field: '+variable_textural_name_list[f]+'['+str(K)+'] = '+format_i+'; [size %zu; type '+variable_type_list[f]+'; variable_name '+variable_name_list[f]+']\\n\",data['+str(K)+'], '+MatPropClass+'_member_sizes['+str(f)+'] );'


		# close stack fram
		print '  }'


	print '}\n'


def write_out_c_class( MatPropClass, MatPropClassShortName, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list ):

	#check length
	L = len(variable_name_list);
	if L != len(variable_type_list):
		print 'ERROR: length variable_name_list[] != variable_name_list[]'
	if L != len(variable_textural_name_list):
		print 'ERROR: length variable_textural_name_list[] != variable_name_list[]'


	print '\n\n\n#error(<<REMOVED AUTOGENERATED TAG>> ================== FILE ['+MatPropClass+'_def.c] ==================)'

	# comment
	now = datetime.datetime.now()
	print '/*'
	print '  Auto generated by version 0.0 of mat_prop_class_generator.py'
	print '  on '+ socket.gethostname() +', at '+str(now)+' by '+os.getenv('USER')
	print '*/\n\n'


	# safe macro
	print '#ifndef __'+MatPropClass+'_DEF_H__'
	print '#define __'+MatPropClass+'_DEF_H__\n'


	# generate struct
	print 'typedef struct {'
	for f in xrange(L):
		if variable_extend_list[f] == 1:
			print ' ', variable_type_list[f], variable_name_list[f], ';'
		else:
			print ' ', variable_type_list[f], variable_name_list[f], '[', variable_extend_list[f], '] ;'

	print '}',MatPropClass,';'
	print '\n'


	# enums #
	print 'typedef enum {'
	for f in xrange(L):
		if f == 0:
			l = '  ' + MatPropClassShortName + '_' + variable_textural_name_list[f] + ' = 0'
		else:
			l = '  ' + MatPropClassShortName + '_' + variable_textural_name_list[f]

		if f < L-1:
			l = l + ','
		print l

	l = '} ' + MatPropClass + 'TypeName ;'
	print l
	print '\n'


	# generate classname
	#print 'const char '+MatPropClass+'_classname[] = "'+MatPropClass+'";\n'
	print 'extern const char '+MatPropClass+'_classname[];\n'

	print 'extern const char '+MatPropClass+'_classname_short[];\n'


	# strings and constant stuff #
#	l = 'const int ' + MatPropClass +'_nmembers = ' + str(L) + ';'
	print 'extern const int ' + MatPropClass +'_nmembers;\n'


	# sizes #
#	l = 'const size_t ' + MatPropClass +'_member_sizes[] = {'
#	print l
#	for f in xrange(L):
#		l = '  ' + str(variable_extend_list[f])  + ' * sizeof(' + str(variable_type_list[f]) +')'
#		if f < L-1:
#			l = l + ','
#		print l
#	print '} ;'
#	print '\n'

	print 'extern const size_t ' + MatPropClass +'_member_sizes[];\n'

	# string names #
#	l = 'const char *' + MatPropClass +'_member_names[] = {'
#	print l
#	for f in xrange(L):
#		l = '  ' + '"' + variable_textural_name_list[f] + '"'
#		if f < L-1:
#			l = l + ','
#		print l
#
#	l = '} ;'
#	print l
#	print '\n'

	print 'extern const char *' + MatPropClass +'_member_names_short[];\n'

	print 'extern const char *' + MatPropClass +'_member_names[];\n'

	print 'extern const size_t ' + MatPropClass +'_member_byte_offset[];\n'


	# dump prototypes here
	print '/* prototypes */'
	write_out_getters( 'True',MatPropClass, MatPropClassShortName, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list )
	write_out_setters( 'True',MatPropClass, MatPropClassShortName, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list )
	write_out_viewer( 'True',MatPropClass, MatPropClassShortName, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list )

	print '\n#endif'


def MATPROP_CLASS_GENERATOR( MatPropClass, MatPropClassShort, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list ):

	# check all arrays have same length
	L = len(variable_name_list);
	if L != len(variable_type_list):
		print 'ERROR: len(variable_name_list) != len(variable_type_list)'
		exit(0);
	if L != len(variable_extend_list):
		print 'ERROR: len(variable_name_list) != len(variable_extend_list)'
		exit(0);
	if L != len(variable_textural_name_list):
		print 'ERROR: len(variable_name_list) != len(variable_textural_name_list)'
		exit(0);


	# check all types are doubles
#	L = len(variable_name_list);
#	for v in xrange(L):
#		if variable_type_list[v] != 'double':
#			print 'ERROR: All variables must be of type double: Please change type of variable named ' + str(variable_name_list[v])
#			exit(0)

	# write out the header
	file = open(MatPropClass+'_def.h','w')
	sys.stdout = file

	write_out_c_class( MatPropClass, MatPropClassShort, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list )

	file.close()
	sys.stdout = sys.__stdout__



	# write out the c file
	file = open(MatPropClass+'_def.c','w')
	sys.stdout = file

	write_out_c_class_externdefs( MatPropClass, MatPropClassShort, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list )
	write_out_getters( 'False', MatPropClass, MatPropClassShort, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list )
	write_out_setters( 'False', MatPropClass, MatPropClassShort, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list )
	write_out_viewer( 'False', MatPropClass, MatPropClassShort, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list )


	file.close()
	sys.stdout = sys.__stdout__

# ==================================================================================

def Generate_pTatin3d_MaterialConstant_MaterialType():
	MatPropClass      = 'MaterialConst_MaterialType'
	MatPropClassShort = 'MaterialType'
	variable_name_list = [ 'visc_type', 'plastic_type', 'softening_type', 'density_type'  ]
	variable_type_list = [ 'int', 'int', 'int', 'int' ]
	variable_extend_list        = [ 1,1,1,1 ]
	variable_textural_name_list = [ 'visc_type', 'plastic_type', 'softening_type', 'density_type' ]

	MATPROP_CLASS_GENERATOR( MatPropClass, MatPropClassShort, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list )


def Generate_pTatin3d_MaterialConstant_ViscosityConst():
	MatPropClass      = 'MaterialConst_ViscosityConst'
	MatPropClassShort = 'ViscConst'
	variable_name_list = [ 'eta0'  ]
	variable_type_list = [ 'double' ]
	variable_extend_list        = [ 1 ]
	variable_textural_name_list = [ 'eta0' ]

	MATPROP_CLASS_GENERATOR( MatPropClass, MatPropClassShort, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list )


def Generate_pTatin3d_MaterialConstant_ViscosityArrhenius():
	MatPropClass      = 'MaterialConst_ViscosityArrhenius'
	MatPropClassShort = 'ViscArrhenius'
	variable_name_list = [ 'enthalpy', 'preexpA', 'nexp',   'Vmol',   'Tref',   'Ascale'  ]
	variable_type_list = [ 'double',   'double',  'double', 'double', 'double', 'double'  ]
	variable_extend_list        = [ 1, 1, 1, 1, 1, 1 ]
	variable_textural_name_list = [ 'enthalpy', 'pre_exponential_factor', 'stres_exponent', 'activation_volume', 'temp_ref', 'Ascale' ]

	MATPROP_CLASS_GENERATOR( MatPropClass, MatPropClassShort, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list )


def Generate_pTatin3d_MaterialConstant_PlasticMises():
	MatPropClass      = 'MaterialConst_PlasticMises'
	MatPropClassShort = 'PlasticMises'
	variable_name_list = [ 'tau_yield',      'tau_yield_inf'  ]
	variable_type_list = [ 'double', 'double' ]
	variable_extend_list        = [ 1, 1 ]
	variable_textural_name_list = [ 'yield_stress', 'yield_stress_inf' ]

	MATPROP_CLASS_GENERATOR( MatPropClass, MatPropClassShort, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list )


def Generate_pTatin3d_MaterialConstant_PlasticDruckerPrager():
	MatPropClass      = 'MaterialConst_PlasticDruckerPrager'
	MatPropClassShort = 'PlasticDP'
	variable_name_list = [ 'Co',      'phi',  'Co_inf', 'phi_inf', 'Hst_cutoff', 'Tst_cutoff'  ]
	variable_type_list = [ 'double', 'double', 'double', 'double', 'double', 'double' ]
	variable_extend_list        = [ 1, 1, 1, 1, 1, 1 ]
	variable_textural_name_list = [ 'cohesion', 'friction_angle', 'Co_inf', 'phi_inf', 'high_stress_cutoff', 'tensile_stress_cutoff' ]

	MATPROP_CLASS_GENERATOR( MatPropClass, MatPropClassShort, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list )


def Generate_pTatin3d_MaterialConstant_Softening():
	MatPropClass      = 'MaterialConst_Softening'
	MatPropClassShort = 'Softening'
	variable_name_list = [ 'min_strain_cutoff',      'max_strain_cutoff'  ]
	variable_type_list = [ 'double', 'double' ]
	variable_extend_list        = [ 1, 1 ]
	variable_textural_name_list = [ 'min_strain_cutoff', 'max_strain_cutoff' ]

	MATPROP_CLASS_GENERATOR( MatPropClass, MatPropClassShort, variable_name_list, variable_type_list, variable_extend_list, variable_textural_name_list )


Generate_pTatin3d_MaterialConstant_MaterialType()

Generate_pTatin3d_MaterialConstant_ViscosityConst()
Generate_pTatin3d_MaterialConstant_ViscosityArrhenius()

# plastic
Generate_pTatin3d_MaterialConstant_PlasticMises()
Generate_pTatin3d_MaterialConstant_PlasticDruckerPrager()

# softening
Generate_pTatin3d_MaterialConstant_Softening()

